/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.RedisCompositeKey;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;

public class RedisGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisGoogleAuthenticatorTokenCredentialRepository.class);
    private final CasRedisTemplates casRedisTemplates;

    public RedisGoogleAuthenticatorTokenCredentialRepository(IGoogleAuthenticator googleAuthenticator, CasRedisTemplates casRedisTemplates, CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher) {
        super(tokenCredentialCipher, scratchCodesCipher, googleAuthenticator);
        this.casRedisTemplates = casRedisTemplates;
    }

    public OneTimeTokenAccount get(String username, long id) {
        return this.get(username).stream().filter(account -> account.getId() == id).findFirst().orElse(null);
    }

    public OneTimeTokenAccount get(long id) {
        String redisAccountKey = RedisCompositeKey.forAccounts().withAccount(id).toKeyPattern();
        OneTimeTokenAccount account = (OneTimeTokenAccount)this.casRedisTemplates.getAccountsRedisTemplate().boundValueOps((Object)redisAccountKey).get();
        return account != null ? this.decode(account) : null;
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        String redisAccountKey = RedisCompositeKey.forPrincipals().withPrincipal(username).toKeyPattern();
        Set accounts = this.casRedisTemplates.getPrincipalsRedisTemplate().boundSetOps((Object)redisAccountKey).members();
        return Objects.requireNonNull(accounts).stream().filter(Objects::nonNull).map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        String keyPattern = RedisCompositeKey.forAccounts().toKeyPattern();
        Set accounts = this.casRedisTemplates.getAccountsRedisTemplate().keys((Object)keyPattern);
        return Objects.requireNonNull(accounts).stream().map(redisKey -> (OneTimeTokenAccount)this.casRedisTemplates.getAccountsRedisTemplate().boundValueOps(redisKey).get()).filter(Objects::nonNull).map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).collect(Collectors.toList());
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        return this.update(account);
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        OneTimeTokenAccount encodedAccount = this.encode(account);
        String redisAccountKey = RedisCompositeKey.forAccounts().withAccount(encodedAccount).toKeyPattern();
        LOGGER.trace("Saving account [{}] using key [{}]", (Object)encodedAccount, (Object)redisAccountKey);
        this.casRedisTemplates.getAccountsRedisTemplate().boundValueOps((Object)redisAccountKey).set((Object)account);
        String redisPrincipalKey = RedisCompositeKey.forPrincipals().withPrincipal(encodedAccount).toKeyPattern();
        LOGGER.trace("Saving principal [{}] using key [{}]", (Object)encodedAccount, (Object)redisPrincipalKey);
        this.casRedisTemplates.getPrincipalsRedisTemplate().boundSetOps((Object)redisPrincipalKey).add((Object[])new OneTimeTokenAccount[]{encodedAccount});
        return encodedAccount;
    }

    public void deleteAll() {
        ScanOptions options = ScanOptions.scanOptions().match(RedisCompositeKey.forAccounts().toKeyPattern()).build();
        try (Cursor result = this.casRedisTemplates.getAccountsRedisTemplate().scan(options);){
            this.casRedisTemplates.getAccountsRedisTemplate().executePipelined(connection -> {
                StreamSupport.stream(result.spliterator(), false).forEach(id -> connection.keyCommands().del((byte[][])new byte[][]{id.getBytes(StandardCharsets.UTF_8)}));
                return null;
            });
        }
        options = ScanOptions.scanOptions().match(RedisCompositeKey.forPrincipals().toKeyPattern()).build();
        result = this.casRedisTemplates.getPrincipalsRedisTemplate().scan(options);
        try {
            this.casRedisTemplates.getPrincipalsRedisTemplate().executePipelined(connection -> {
                StreamSupport.stream(result.spliterator(), false).forEach(id -> connection.keyCommands().del((byte[][])new byte[][]{id.getBytes(StandardCharsets.UTF_8)}));
                return null;
            });
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    public void delete(String username) {
        String redisKeyPattern = RedisCompositeKey.forPrincipals().withPrincipal(username).toKeyPattern();
        Set accounts = this.casRedisTemplates.getPrincipalsRedisTemplate().boundSetOps((Object)redisKeyPattern).members();
        this.casRedisTemplates.getAccountsRedisTemplate().executePipelined(connection -> {
            StreamSupport.stream(Objects.requireNonNull(accounts).spliterator(), false).forEach(account -> {
                String accountKey = RedisCompositeKey.forAccounts().withAccount((OneTimeTokenAccount)account).toKeyPattern();
                connection.keyCommands().del((byte[][])new byte[][]{accountKey.getBytes(StandardCharsets.UTF_8)});
            });
            return null;
        });
        this.casRedisTemplates.getPrincipalsRedisTemplate().delete((Object)redisKeyPattern);
    }

    public void delete(long id) {
        String accountKey = RedisCompositeKey.forAccounts().withAccount(id).toKeyPattern();
        this.casRedisTemplates.getAccountsRedisTemplate().delete((Object)accountKey);
    }

    public long count() {
        String redisKeyPattern = RedisCompositeKey.forAccounts().toKeyPattern();
        Set accounts = Objects.requireNonNull(this.casRedisTemplates.getAccountsRedisTemplate().keys((Object)redisKeyPattern));
        return accounts.isEmpty() ? 0L : this.casRedisTemplates.getAccountsRedisTemplate().countExistingKeys((Collection)accounts);
    }

    public long count(String username) {
        String redisKeyPattern = RedisCompositeKey.forPrincipals().withPrincipal(username).toKeyPattern();
        return this.casRedisTemplates.getPrincipalsRedisTemplate().boundSetOps((Object)redisKeyPattern).size();
    }

    @Generated
    public String toString() {
        return "RedisGoogleAuthenticatorTokenCredentialRepository(casRedisTemplates=" + String.valueOf(this.casRedisTemplates) + ")";
    }

    @Generated
    public CasRedisTemplates getCasRedisTemplates() {
        return this.casRedisTemplates;
    }

    public static class CasRedisTemplates {
        private final CasRedisTemplate<String, OneTimeTokenAccount> accountsRedisTemplate;
        private final CasRedisTemplate<String, OneTimeTokenAccount> principalsRedisTemplate;

        @Generated
        public CasRedisTemplates(CasRedisTemplate<String, OneTimeTokenAccount> accountsRedisTemplate, CasRedisTemplate<String, OneTimeTokenAccount> principalsRedisTemplate) {
            this.accountsRedisTemplate = accountsRedisTemplate;
            this.principalsRedisTemplate = principalsRedisTemplate;
        }

        @Generated
        public CasRedisTemplate<String, OneTimeTokenAccount> getAccountsRedisTemplate() {
            return this.accountsRedisTemplate;
        }

        @Generated
        public CasRedisTemplate<String, OneTimeTokenAccount> getPrincipalsRedisTemplate() {
            return this.principalsRedisTemplate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CasRedisTemplates)) {
                return false;
            }
            CasRedisTemplates other = (CasRedisTemplates)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CasRedisTemplate<String, OneTimeTokenAccount> this$accountsRedisTemplate = this.accountsRedisTemplate;
            CasRedisTemplate<String, OneTimeTokenAccount> other$accountsRedisTemplate = other.accountsRedisTemplate;
            if (this$accountsRedisTemplate == null ? other$accountsRedisTemplate != null : !this$accountsRedisTemplate.equals(other$accountsRedisTemplate)) {
                return false;
            }
            CasRedisTemplate<String, OneTimeTokenAccount> this$principalsRedisTemplate = this.principalsRedisTemplate;
            CasRedisTemplate<String, OneTimeTokenAccount> other$principalsRedisTemplate = other.principalsRedisTemplate;
            return !(this$principalsRedisTemplate == null ? other$principalsRedisTemplate != null : !this$principalsRedisTemplate.equals(other$principalsRedisTemplate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CasRedisTemplates;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CasRedisTemplate<String, OneTimeTokenAccount> $accountsRedisTemplate = this.accountsRedisTemplate;
            result = result * 59 + ($accountsRedisTemplate == null ? 43 : $accountsRedisTemplate.hashCode());
            CasRedisTemplate<String, OneTimeTokenAccount> $principalsRedisTemplate = this.principalsRedisTemplate;
            result = result * 59 + ($principalsRedisTemplate == null ? 43 : $principalsRedisTemplate.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RedisGoogleAuthenticatorTokenCredentialRepository.CasRedisTemplates(accountsRedisTemplate=" + String.valueOf(this.accountsRedisTemplate) + ", principalsRedisTemplate=" + String.valueOf(this.principalsRedisTemplate) + ")";
        }
    }
}

