/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.token;

import java.time.Duration;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.token.BaseOneTimeTokenRepository;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundValueOperations;

public class GoogleAuthenticatorRedisTokenRepository
extends BaseOneTimeTokenRepository<GoogleAuthenticatorToken> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorRedisTokenRepository.class);
    private static final String KEY_SEPARATOR = ":";
    private static final String CAS_PREFIX = GoogleAuthenticatorRedisTokenRepository.class.getSimpleName();
    private final CasRedisTemplate<String, GoogleAuthenticatorToken> template;
    private final long expireTokensInSeconds;
    private final long scanCount;

    public void store(GoogleAuthenticatorToken token) {
        String redisKey = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(token);
        LOGGER.trace("Saving token [{}] using key [{}]", (Object)token, (Object)redisKey);
        BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
        ops.set((Object)token);
        ops.expire(Duration.ofSeconds(this.expireTokensInSeconds));
        LOGGER.trace("Saved token [{}]", (Object)token);
    }

    public GoogleAuthenticatorToken get(String uid, Integer otp) {
        String redisKey = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(uid, otp);
        BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
        LOGGER.trace("Locating token by identifier [{}] using key [{}]", (Object)uid, (Object)redisKey);
        return (GoogleAuthenticatorToken)ops.get();
    }

    public void removeAll() {
        try (Stream<String> keys = this.getGoogleAuthenticatorTokenKeys();){
            Set redisKey = keys.collect(Collectors.toSet());
            LOGGER.trace("Deleting tokens using key [{}]", redisKey);
            this.template.delete(redisKey);
        }
    }

    public void remove(String uid, Integer otp) {
        String redisKey = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(uid, otp);
        LOGGER.trace("Deleting token [{}] for [{}] using key [{}]", new Object[]{otp, uid, redisKey});
        this.template.delete((Object)redisKey);
        LOGGER.trace("Deleted token [{}]", (Object)redisKey);
    }

    public void remove(String uid) {
        try (Stream<String> keys = this.getGoogleAuthenticatorTokenKeys(uid);){
            Set redisKey = keys.collect(Collectors.toSet());
            LOGGER.trace("Deleting tokens for [{}] using key [{}]", (Object)uid, redisKey);
            this.template.delete(redisKey);
            LOGGER.trace("Deleted tokens [{}]", redisKey);
        }
    }

    public void remove(Integer otp) {
        try (Stream<String> keys = this.getGoogleAuthenticatorTokenKeys(otp);){
            Set redisKey = keys.collect(Collectors.toSet());
            LOGGER.trace("Deleting token for [{}] using key [{}]", (Object)otp, redisKey);
            this.template.delete(redisKey);
            LOGGER.trace("Deleted tokens [{}]", redisKey);
        }
    }

    public long count(String uid) {
        try (Stream<String> keys = this.getGoogleAuthenticatorTokenKeys(uid);){
            long l = keys.count();
            return l;
        }
    }

    public long count() {
        try (Stream<String> keys = this.getGoogleAuthenticatorTokenKeys();){
            long l = keys.count();
            return l;
        }
    }

    private static String getGoogleAuthenticatorTokenRedisKey(GoogleAuthenticatorToken token) {
        return GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(token.getUserId(), token.getToken());
    }

    private static String getGoogleAuthenticatorTokenRedisKey(String username, Integer otp) {
        return CAS_PREFIX + KEY_SEPARATOR + username.trim().toLowerCase(Locale.ENGLISH) + KEY_SEPARATOR + otp;
    }

    private static String getGoogleAuthenticatorTokenRedisKey(String username) {
        return CAS_PREFIX + KEY_SEPARATOR + username.trim().toLowerCase(Locale.ENGLISH) + ":*";
    }

    private static String getGoogleAuthenticatorTokenRedisKey(Integer otp) {
        return CAS_PREFIX + ":*:" + otp;
    }

    private static String getPatternGoogleAuthenticatorTokenRedisKey() {
        return CAS_PREFIX + ":*";
    }

    private Stream<String> getGoogleAuthenticatorTokenKeys() {
        String key = GoogleAuthenticatorRedisTokenRepository.getPatternGoogleAuthenticatorTokenRedisKey();
        LOGGER.trace("Fetching Google Authenticator records based on key [{}]", (Object)key);
        return this.template.scan(key, Long.valueOf(this.scanCount));
    }

    private Stream<String> getGoogleAuthenticatorTokenKeys(String username) {
        String key = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(username);
        LOGGER.trace("Fetching Google Authenticator records based on key [{}] for [{}]", (Object)key, (Object)username);
        return this.template.scan(key, Long.valueOf(this.scanCount));
    }

    private Stream<String> getGoogleAuthenticatorTokenKeys(Integer otp) {
        String key = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(otp);
        LOGGER.trace("Fetching Google Authenticator records based on key [{}] for [{}]", (Object)key, (Object)otp);
        return this.template.scan(key, Long.valueOf(this.scanCount));
    }

    protected void cleanInternal() {
    }

    @Generated
    public GoogleAuthenticatorRedisTokenRepository(CasRedisTemplate<String, GoogleAuthenticatorToken> template, long expireTokensInSeconds, long scanCount) {
        this.template = template;
        this.expireTokensInSeconds = expireTokensInSeconds;
        this.scanCount = scanCount;
    }
}

