/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.RestGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

@SpringBootTest(classes={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.rest.url=http://example.com"})
@Tag(value="MFA")
public class RestGoogleAuthenticatorTokenCredentialRepositoryTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    @Qualifier(value="googleAuthenticatorInstance")
    private IGoogleAuthenticator googleAuthenticatorInstance;

    @Test
    public void verifyFailOps() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8551");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        String entity = MAPPER.writeValueAsString(List.of("----"));
        try (MockWebServer webServer = new MockWebServer(8551, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertNull((Object)repo.get("casuser", 1L));
            Assertions.assertNull((Object)repo.get(1L));
            Assertions.assertNull((Object)repo.get("casuser"));
            Assertions.assertEquals((long)0L, (long)repo.count());
            Assertions.assertEquals((long)0L, (long)repo.count("casuser"));
            Assertions.assertNull((Object)repo.update(null));
        }
    }

    @Test
    public void verifyLoad() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8551");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)CollectionUtils.wrapArrayList((Object[])new OneTimeTokenAccount[]{account}));
        try (MockWebServer webServer = new MockWebServer(8551, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertFalse((boolean)repo.load().isEmpty());
        }
    }

    @Test
    public void verifyDelete() {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8550");
        final RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        try (MockWebServer webServer = new MockWebServer(8550, (Resource)new ByteArrayResource("1".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertDoesNotThrow((Executable)new Executable(){

                public void execute() {
                    repo.delete("casuser");
                    repo.delete(12345L);
                    repo.deleteAll();
                }
            });
        }
    }

    @Test
    public void verifyGet() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8552");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)CollectionUtils.wrapList((Object[])new OneTimeTokenAccount[]{account}));
        try (MockWebServer webServer = new MockWebServer(8552, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Results"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertFalse((boolean)repo.get(account.getUsername()).isEmpty());
        }
    }

    @Test
    public void verifyGetById() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8552");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)account);
        try (MockWebServer webServer = new MockWebServer(8552, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Results"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertNotNull((Object)repo.get(account.getId()));
        }
    }

    @Test
    public void verifyGetByIdAndUser() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8552");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)account);
        try (MockWebServer webServer = new MockWebServer(8552, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Results"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertNotNull((Object)repo.get(account.getUsername(), account.getId()));
        }
    }

    @Test
    public void verifyCount() {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8552");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        try (MockWebServer webServer = new MockWebServer(8552, (Resource)new ByteArrayResource("1".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertEquals((long)1L, (long)repo.count());
        }
    }

    @Test
    public void verifyCountByUser() {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8596");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        try (MockWebServer webServer = new MockWebServer(8596, (Resource)new ByteArrayResource("1".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertEquals((long)1L, (long)repo.count("casuser"));
        }
    }

    @Test
    public void verifySave() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8553");
        final RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        final OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)account);
        try (MockWebServer webServer = new MockWebServer(8553, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertDoesNotThrow((Executable)new Executable(){

                public void execute() {
                    OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(account.getUsername()).secretKey(account.getSecretKey()).validationCode(0).scratchCodes(List.of()).name(UUID.randomUUID().toString()).build();
                    repo.save(toSave);
                }
            });
        }
    }

    @Test
    public void verifySaveFail() {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8554");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        try (MockWebServer webServer = new MockWebServer(8554, (Resource)new ByteArrayResource("".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.BAD_REQUEST);){
            webServer.start();
            Assertions.assertNull((Object)repo.update(account));
        }
    }

    @Generated
    public IGoogleAuthenticator getGoogleAuthenticatorInstance() {
        return this.googleAuthenticatorInstance;
    }
}

