/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import com.warrenstrange.googleauth.KeyRepresentation;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.GoogleAuthenticatorAuthenticationHandler;
import org.apereo.cas.gauth.GoogleAuthenticatorMultifactorAuthenticationProvider;
import org.apereo.cas.gauth.GoogleAuthenticatorService;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorOneTimeTokenCredentialValidator;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredentialRepositoryEndpoint;
import org.apereo.cas.gauth.credential.InMemoryGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.JsonGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.RestGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorDeleteAccountAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorPrepareLoginAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorSaveRegistrationAction;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorValidateSelectedRegistrationAction;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenAccountCipherExecutor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepositoryCleaner;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountCheckRegistrationAction;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountConfirmSelectionRegistrationAction;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountCreateRegistrationAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.webflow.execution.Action;

@Configuration(value="googleAuthenticatorAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration.class);
    @Lazy
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private ObjectProvider<OneTimeTokenCredentialRepository> googleAuthenticatorAccountRegistry;
    @Autowired
    @Qualifier(value="googleAuthenticatorBypassEvaluator")
    private ObjectProvider<MultifactorAuthenticationProviderBypassEvaluator> googleAuthenticatorBypassEvaluator;
    @Lazy
    @Autowired
    @Qualifier(value="oneTimeTokenAuthenticatorTokenRepository")
    private ObjectProvider<OneTimeTokenRepository> oneTimeTokenAuthenticatorTokenRepository;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="failureModeEvaluator")
    private ObjectProvider<MultifactorAuthenticationFailureModeEvaluator> failureModeEvaluator;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"googleAuthenticatorInstance"})
    public IGoogleAuthenticator googleAuthenticatorInstance() {
        CoreGoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth().getCore();
        GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder bldr = new GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder();
        bldr.setCodeDigits(gauth.getCodeDigits());
        bldr.setTimeStepSizeInMillis(TimeUnit.SECONDS.toMillis(gauth.getTimeStepSize()));
        bldr.setWindowSize(gauth.getWindowSize());
        bldr.setKeyRepresentation(KeyRepresentation.BASE32);
        return new GoogleAuthenticatorService(new GoogleAuthenticator(bldr.build()));
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationHandler"})
    @Bean
    @RefreshScope
    public AuthenticationHandler googleAuthenticatorAuthenticationHandler() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        return new GoogleAuthenticatorAuthenticationHandler(gauth.getName(), (ServicesManager)this.servicesManager.getObject(), this.googlePrincipalFactory(), this.googleAuthenticatorOneTimeTokenCredentialValidator(), Integer.valueOf(gauth.getOrder()));
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorOneTimeTokenCredentialValidator"})
    @Bean
    @RefreshScope
    public OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> googleAuthenticatorOneTimeTokenCredentialValidator() {
        return new GoogleAuthenticatorOneTimeTokenCredentialValidator(this.googleAuthenticatorInstance(), (OneTimeTokenRepository)this.oneTimeTokenAuthenticatorTokenRepository.getObject(), (OneTimeTokenCredentialRepository)this.googleAuthenticatorAccountRegistry.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorMultifactorAuthenticationProvider"})
    public MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        GoogleAuthenticatorMultifactorAuthenticationProvider p = new GoogleAuthenticatorMultifactorAuthenticationProvider();
        p.setBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)this.googleAuthenticatorBypassEvaluator.getObject());
        p.setFailureMode(gauth.getFailureMode());
        p.setFailureModeEvaluator((MultifactorAuthenticationFailureModeEvaluator)this.failureModeEvaluator.getObject());
        p.setOrder(gauth.getRank());
        p.setId(gauth.getId());
        return p;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationMetaDataPopulator"})
    public AuthenticationMetaDataPopulator googleAuthenticatorAuthenticationMetaDataPopulator() {
        return new AuthenticationContextAttributeMetaDataPopulator(this.casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), this.googleAuthenticatorAuthenticationHandler(), this.googleAuthenticatorMultifactorAuthenticationProvider().getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"prepareGoogleAuthenticatorLoginAction"})
    public Action prepareGoogleAuthenticatorLoginAction() {
        return new GoogleAuthenticatorPrepareLoginAction(this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAccountCheckRegistrationAction"})
    public Action googleAccountCheckRegistrationAction() {
        return new OneTimeTokenAccountCheckRegistrationAction((OneTimeTokenCredentialRepository)this.googleAuthenticatorAccountRegistry.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAccountConfirmSelectionAction"})
    public Action googleAccountConfirmSelectionAction() {
        return new OneTimeTokenAccountConfirmSelectionRegistrationAction((OneTimeTokenCredentialRepository)this.googleAuthenticatorAccountRegistry.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAccountDeleteDeviceAction"})
    public Action googleAccountDeleteDeviceAction() {
        return new GoogleAuthenticatorDeleteAccountAction((OneTimeTokenCredentialRepository)this.googleAuthenticatorAccountRegistry.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAccountCreateRegistrationAction"})
    public Action googleAccountCreateRegistrationAction() {
        CoreGoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth().getCore();
        return new OneTimeTokenAccountCreateRegistrationAction((OneTimeTokenCredentialRepository)this.googleAuthenticatorAccountRegistry.getObject(), gauth.getLabel(), gauth.getIssuer());
    }

    @ConditionalOnProperty(prefix="cas.authn.mfa.gauth.cleaner.schedule", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    @Autowired
    public OneTimeTokenRepositoryCleaner googleAuthenticatorTokenRepositoryCleaner(@Qualifier(value="oneTimeTokenAuthenticatorTokenRepository") OneTimeTokenRepository repository) {
        return new GoogleAuthenticatorOneTimeTokenRepositoryCleaner(repository);
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorAccountRegistry"})
    @Bean
    @RefreshScope
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        if (gauth.getJson().getLocation() != null) {
            return new JsonGoogleAuthenticatorTokenCredentialRepository(gauth.getJson().getLocation(), this.googleAuthenticatorInstance(), this.googleAuthenticatorAccountCipherExecutor());
        }
        if (StringUtils.isNotBlank((CharSequence)gauth.getRest().getUrl())) {
            return new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance(), gauth, this.googleAuthenticatorAccountCipherExecutor());
        }
        return new InMemoryGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorAccountCipherExecutor(), this.googleAuthenticatorInstance());
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public GoogleAuthenticatorTokenCredentialRepositoryEndpoint googleAuthenticatorTokenCredentialRepositoryEndpoint() {
        return new GoogleAuthenticatorTokenCredentialRepositoryEndpoint(this.casProperties, this.googleAuthenticatorAccountRegistry());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorAccountCipherExecutor"})
    @Bean
    @RefreshScope
    public CipherExecutor googleAuthenticatorAccountCipherExecutor() {
        EncryptionJwtSigningJwtCryptographyProperties crypto = this.casProperties.getAuthn().getMfa().getGauth().getCrypto();
        if (crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, OneTimeTokenAccountCipherExecutor.class);
        }
        LOGGER.warn("Google Authenticator one-time token account encryption/signing is turned off. Consider turning on encryption, signing to securely and safely store one-time token accounts.");
        return CipherExecutor.noOp();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleSaveAccountRegistrationAction"})
    public Action googleSaveAccountRegistrationAction() {
        return new GoogleAuthenticatorSaveRegistrationAction(this.googleAuthenticatorAccountRegistry(), this.casProperties, this.googleAuthenticatorOneTimeTokenCredentialValidator());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"validateSelectedRegistrationAction"})
    public Action validateSelectedRegistrationAction() {
        return new GoogleAuthenticatorValidateSelectedRegistrationAction();
    }

    @ConditionalOnMissingBean(name={"googlePrincipalFactory"})
    @Bean
    public PrincipalFactory googlePrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer googleAuthenticatorAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getMfa().getGauth().getCore().getIssuer())) {
                plan.registerAuthenticationHandler(this.googleAuthenticatorAuthenticationHandler());
                plan.registerAuthenticationMetadataPopulator(this.googleAuthenticatorAuthenticationMetaDataPopulator());
                plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{GoogleAuthenticatorTokenCredential.class}));
            }
        };
    }

    public static class GoogleAuthenticatorOneTimeTokenRepositoryCleaner
    extends OneTimeTokenRepositoryCleaner {
        public GoogleAuthenticatorOneTimeTokenRepositoryCleaner(OneTimeTokenRepository tokenRepository) {
            super(tokenRepository);
        }

        @Scheduled(initialDelayString="${cas.authn.mfa.gauth.cleaner.schedule.start-delay:PT30S}", fixedDelayString="${cas.authn.mfa.gauth.cleaner.schedule.repeat-interval:PT35S}")
        public void clean() {
            super.clean();
        }
    }
}

