/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.grouper;

import edu.internet2.middleware.grouperClient.api.GcGetGroups;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import java.util.List;
import java.util.Map;
import org.apereo.cas.BaseGrouperConfigurationTests;
import org.apereo.cas.authentication.attribute.PrincipalAttributeRepositoryFetcher;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.GrouperPersonAttributeDao;
import org.apereo.services.persondir.support.IUsernameAttributeProvider;
import org.apereo.services.persondir.support.SimpleUsernameAttributeProvider;
import org.assertj.core.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;

@Tag(value="Grouper")
@SpringBootTest(classes={GrouperPersonAttributeDaoTestConfiguration.class, BaseGrouperConfigurationTests.SharedTestConfiguration.class}, properties={"cas.authn.attribute-repository.stub.attributes.uid=casuser", "cas.authn.attribute-repository.stub.attributes.givenName=apereo-cas", "cas.authn.attribute-repository.stub.attributes.phone=123456789"})
public class GrouperPersonAttributeDaoTests {
    @Autowired
    @Qualifier(value="aggregatingAttributeRepository")
    private IPersonAttributeDao aggregatingAttributeRepository;

    @Test
    public void verifyOperation() {
        Map attributes = PrincipalAttributeRepositoryFetcher.builder().attributeRepository(this.aggregatingAttributeRepository).principalId("casuser").build().retrieve();
        Assertions.assertTrue((boolean)attributes.containsKey("grouperGroups"));
        Assertions.assertTrue((boolean)attributes.containsKey("givenName"));
        Assertions.assertTrue((boolean)attributes.containsKey("phone"));
    }

    @TestConfiguration(value="GrouperPersonAttributeDaoTestConfiguration", proxyBeanMethods=false)
    public static class GrouperPersonAttributeDaoTestConfiguration
    implements PersonDirectoryAttributeRepositoryPlanConfigurer {
        public void configureAttributeRepositoryPlan(PersonDirectoryAttributeRepositoryPlan plan) {
            GrouperPersonAttributeDao dao = new GrouperPersonAttributeDao(){

                protected GcGetGroups getGroupsClient() {
                    WsGroup group = (WsGroup)Mockito.mock(WsGroup.class);
                    Mockito.when((Object)group.getName()).thenReturn((Object)"Group1");
                    WsGetGroupsResult result = (WsGetGroupsResult)Mockito.mock(WsGetGroupsResult.class);
                    Mockito.when((Object)result.getWsGroups()).thenReturn((Object)((WsGroup[])Arrays.array((Object[])new WsGroup[]{group})));
                    WsGetGroupsResults results = (WsGetGroupsResults)Mockito.mock(WsGetGroupsResults.class);
                    Mockito.when((Object)results.getResults()).thenReturn((Object)((WsGetGroupsResult[])Arrays.array((Object[])new WsGetGroupsResult[]{result})));
                    GcGetGroups gc = (GcGetGroups)Mockito.mock(GcGetGroups.class);
                    Mockito.when((Object)gc.execute()).thenReturn((Object)results);
                    return gc;
                }
            };
            dao.setUsernameAttributeProvider((IUsernameAttributeProvider)new SimpleUsernameAttributeProvider("username"));
            plan.registerAttributeRepositories(List.of(dao));
        }
    }
}

