/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.grouper.services;

import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.grouper.services.GrouperRegisteredServiceAccessStrategy;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.JsonServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.replication.NoOpRegisteredServiceReplicationStrategy;
import org.apereo.cas.services.replication.RegisteredServiceReplicationStrategy;
import org.apereo.cas.services.resource.DefaultRegisteredServiceResourceNamingStrategy;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.io.WatcherService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Tag(value="RegisteredService")
public class GrouperRegisteredServiceAccessStrategyTests {
    private static final ClassPathResource RESOURCE = new ClassPathResource("services");

    @BeforeAll
    public static void prepTests() throws Exception {
        FileUtils.cleanDirectory((File)RESOURCE.getFile());
    }

    @Test
    public void checkAccessStrategyJson() throws Exception {
        HashMap attributes = new HashMap();
        HashSet<String> v1 = new HashSet<String>();
        v1.add("admin");
        attributes.put("memberOf", v1);
        AbstractRegisteredService service = RegisteredServiceTestUtils.getRegisteredService((String)"test");
        GrouperRegisteredServiceAccessStrategy grouper = new GrouperRegisteredServiceAccessStrategy();
        grouper.setConfigProperties(CollectionUtils.wrap((String)"hello", (Object)"world"));
        grouper.setRequiredAttributes(attributes);
        service.setAccessStrategy((RegisteredServiceAccessStrategy)grouper);
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        JsonServiceRegistry dao = new JsonServiceRegistry((Resource)RESOURCE, WatcherService.noOp(), (ConfigurableApplicationContext)appCtx, (RegisteredServiceReplicationStrategy)new NoOpRegisteredServiceReplicationStrategy(), (RegisteredServiceResourceNamingStrategy)new DefaultRegisteredServiceResourceNamingStrategy(), new ArrayList());
        RegisteredService saved = dao.save((RegisteredService)service);
        Assertions.assertEquals((Object)service, (Object)saved);
        Assertions.assertFalse((boolean)dao.load().isEmpty());
    }

    @Test
    public void checkGrouperAttributes() {
        GrouperRegisteredServiceAccessStrategy strategy = new GrouperRegisteredServiceAccessStrategy(){
            private static final long serialVersionUID = 8533229193475808261L;

            protected Collection<WsGetGroupsResult> fetchWsGetGroupsResults(String principal) {
                WsGroup group = new WsGroup();
                group.setExtension("GroupExtension");
                group.setDescription("Group Desc");
                group.setName("SampleGroup");
                group.setUuid(UUID.randomUUID().toString());
                WsGetGroupsResult result = new WsGetGroupsResult();
                result.setWsGroups(new WsGroup[]{group});
                return List.of(result);
            }
        };
        HashMap<String, Set<String>> requiredAttributes = new HashMap<String, Set<String>>();
        requiredAttributes.put("grouperAttributes", Collections.singleton("SampleGroup"));
        strategy.setRequiredAttributes(requiredAttributes);
        Map attrs = RegisteredServiceTestUtils.getTestAttributes((String)"banderson");
        Assertions.assertTrue((boolean)strategy.doPrincipalAttributesAllowServiceAccess("banderson", attrs));
    }

    @Test
    public void checkGrouperNoGroups() {
        GrouperRegisteredServiceAccessStrategy strategy = new GrouperRegisteredServiceAccessStrategy(){
            private static final long serialVersionUID = 8533229193475808261L;

            protected Collection<WsGetGroupsResult> fetchWsGetGroupsResults(String principal) {
                return List.of();
            }
        };
        Map attrs = RegisteredServiceTestUtils.getTestAttributes((String)"banderson");
        Assertions.assertFalse((boolean)strategy.doPrincipalAttributesAllowServiceAccess("banderson", attrs));
    }

    @Test
    public void checkFailsConfig() {
        GrouperRegisteredServiceAccessStrategy strategy = new GrouperRegisteredServiceAccessStrategy();
        strategy.getConfigProperties().put("grouperClient.webService.url", "http://localhost:8012");
        strategy.getConfigProperties().put("grouperClient.webService.login", "unknown");
        strategy.getConfigProperties().put("grouperClient.webService.password", "unknown");
        Map attrs = RegisteredServiceTestUtils.getTestAttributes((String)"banderson");
        Assertions.assertFalse((boolean)strategy.doPrincipalAttributesAllowServiceAccess("banderson", attrs));
    }
}

