/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import edu.internet2.middleware.grouperClient.ws.beans.WsGetGroupsResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.BaseGrouperConfigurationTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.grouper.GrouperFacade;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={BaseGrouperConfigurationTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.triggers.grouper.grouper-group-field=NAME"})
@Tag(value="Grouper")
public class GrouperMultifactorAuthenticationPolicyEventResolverTests {
    @Autowired
    @Qualifier(value="grouperMultifactorAuthenticationWebflowEventResolver")
    protected CasWebflowEventResolver resolver;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Test
    public void verifyOperation() {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication(), (RequestContext)context);
        DefaultTargetStateResolver targetResolver = new DefaultTargetStateResolver("mfa-dummy");
        Transition transition = new Transition((TransitionCriteria)new DefaultTransitionCriteria((Expression)new LiteralExpression("mfa-dummy")), (TargetStateResolver)targetResolver);
        context.getRootFlow().getGlobalTransitionSet().add(transition);
        Set event = this.resolver.resolve((RequestContext)context);
        Assertions.assertEquals((int)1, (int)event.size());
        Assertions.assertEquals((Object)"mfa-dummy", (Object)((Event)event.iterator().next()).getId());
    }

    @TestConfiguration(value="GrouperTestConfiguration", proxyBeanMethods=false)
    public static class GrouperTestConfiguration {
        @Bean
        public GrouperFacade grouperFacade() {
            WsGroup group = new WsGroup();
            group.setName("mfa-dummy");
            group.setDisplayName("Apereo CAS");
            group.setDescription("CAS Authentication with Apereo");
            WsGetGroupsResult result = new WsGetGroupsResult();
            result.setWsGroups(new WsGroup[]{group});
            GrouperFacade facade = (GrouperFacade)Mockito.mock(GrouperFacade.class);
            Mockito.when((Object)facade.getGroupsForSubjectId(Mockito.anyString())).thenReturn((Object)CollectionUtils.wrapList((Object[])new WsGetGroupsResult[]{result}));
            return facade;
        }
    }
}

