/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.grouper.GrouperFacade;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.flow.GrouperMultifactorAuthenticationTrigger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="Grouper")
public class GrouperMultifactorAuthenticationTriggerTests {
    @Test
    public void verifyOperationFails() {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        CasConfigurationProperties casProperties = new CasConfigurationProperties();
        GrouperMultifactorAuthenticationTrigger trigger = new GrouperMultifactorAuthenticationTrigger(casProperties, (MultifactorAuthenticationProviderResolver)Mockito.mock(MultifactorAuthenticationProviderResolver.class), (GrouperFacade)Mockito.mock(GrouperFacade.class), (ApplicationContext)applicationContext);
        Assertions.assertTrue((boolean)trigger.isActivated(RegisteredServiceTestUtils.getAuthentication(), (RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), (Service)RegisteredServiceTestUtils.getService()).isEmpty());
        casProperties.getAuthn().getMfa().getTriggers().getGrouper().setGrouperGroupField("name");
        Assertions.assertTrue((boolean)trigger.isActivated(RegisteredServiceTestUtils.getAuthentication(), null, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), (Service)RegisteredServiceTestUtils.getService()).isEmpty());
        Assertions.assertThrows(AuthenticationException.class, () -> trigger.isActivated(RegisteredServiceTestUtils.getAuthentication(), (RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), (Service)RegisteredServiceTestUtils.getService()));
    }
}

