/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gua.impl;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.AbstractGraphicalAuthenticationTests;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.gua.LdapGraphicalUserAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.gua.api.UserGraphicalAuthenticationRepository;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ClassPathResource;

@Tag(value="LdapAuthentication")
@ExtendWith(value={CasTestExtension.class})
@SpringBootTest(classes={AbstractGraphicalAuthenticationTests.SharedTestConfiguration.class}, properties={"cas.authn.gua.ldap.base-dn=dc=example,dc=org", "cas.authn.gua.ldap.ldap-url=ldap://localhost:10389", "cas.authn.gua.ldap.search-filter=cn={user}", "cas.authn.gua.ldap.image-attribute=jpegPhoto", "cas.authn.gua.ldap.bind-dn=cn=Directory Manager", "cas.authn.gua.ldap.bind-credential=password"})
@EnabledIfListeningOnPort(port={10389})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class LdapUserGraphicalAuthenticationRepositoryTests {
    @Autowired
    @Qualifier(value="userGraphicalAuthenticationRepository")
    private UserGraphicalAuthenticationRepository userGraphicalAuthenticationRepository;
    @Autowired
    private CasConfigurationProperties casProperties;

    LdapUserGraphicalAuthenticationRepositoryTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        LdapGraphicalUserAuthenticationProperties ldap = this.casProperties.getAuthn().getGua().getLdap();
        ConnectionFactory factory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        String cn = LdapUserGraphicalAuthenticationRepositoryTests.createLdapEntry(factory);
        Assertions.assertFalse((boolean)this.userGraphicalAuthenticationRepository.getGraphics(cn).isEmpty());
        Assertions.assertTrue((boolean)this.userGraphicalAuthenticationRepository.getGraphics("bad-user").isEmpty());
    }

    private static String createLdapEntry(ConnectionFactory factory) throws Exception {
        byte[] photo = IOUtils.toByteArray((InputStream)new ClassPathResource("image.jpg").getInputStream());
        String cn = RandomUtils.randomAlphabetic((int)6).toLowerCase(Locale.ENGLISH);
        AddRequest request = (AddRequest)AddRequest.builder().attributes(List.of(new LdapAttribute("objectclass", new String[]{"top", "person", "inetOrgPerson"}), new LdapAttribute("cn", new String[]{cn}), new LdapAttribute("jpegPhoto", (byte[][])new byte[][]{photo}), new LdapAttribute("sn", new String[]{cn}))).dn("cn=" + cn + ",ou=People,dc=example,dc=org").build();
        AddOperation operation = new AddOperation(factory);
        operation.execute(request);
        return cn;
    }
}

