/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.AbstractGraphicalAuthenticationTests;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Tag(value="WebflowAuthenticationActions")
class DisplayUserGraphicsBeforeAuthenticationActionTests
extends AbstractGraphicalAuthenticationTests {
    DisplayUserGraphicsBeforeAuthenticationActionTests() {
    }

    @Test
    void verifyAction() throws Throwable {
        MockRequestContext context = MockRequestContext.create((ApplicationContext)this.applicationContext);
        context.setParameter("username", "casuser");
        Event event = this.displayUserGraphicsBeforeAuthenticationAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
        Assertions.assertTrue((boolean)WebUtils.containsGraphicalUserAuthenticationImage((RequestContext)context));
        Assertions.assertTrue((boolean)WebUtils.containsGraphicalUserAuthenticationUsername((RequestContext)context));
    }

    @Test
    void verifyMissingUser() throws Throwable {
        MockRequestContext context = MockRequestContext.create((ApplicationContext)this.applicationContext);
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.displayUserGraphicsBeforeAuthenticationAction.execute((RequestContext)context));
    }
}

