/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.ldap;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.util.LdapTestUtils;
import org.apereo.cas.util.ldap.uboundid.InMemoryTestLdapDirectoryServer;
import org.ldaptive.BindRequest;
import org.springframework.core.io.ClassPathResource;

public class LdapIntegrationTestsOperations {
    private static final Map<Integer, InMemoryTestLdapDirectoryServer> DIRECTORY_MAP = new HashMap<Integer, InMemoryTestLdapDirectoryServer>();

    public static synchronized void initDirectoryServer(InputStream ldifFile, int port) {
        try {
            boolean createInstance;
            InMemoryTestLdapDirectoryServer directory = DIRECTORY_MAP.get(port);
            boolean bl = createInstance = directory == null || !directory.isAlive();
            if (createInstance) {
                ClassPathResource properties = new ClassPathResource("ldapserver.properties");
                ClassPathResource schema = new ClassPathResource("schema/standard-ldap.schema");
                DIRECTORY_MAP.put(port, new InMemoryTestLdapDirectoryServer(properties.getInputStream(), ldifFile, schema.getInputStream(), port));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void initDirectoryServer(int port) throws IOException {
        LdapIntegrationTestsOperations.initDirectoryServer(new ClassPathResource("ldif/ldap-base.ldif").getInputStream(), port);
    }

    public static InMemoryTestLdapDirectoryServer getLdapDirectory(int port) {
        return DIRECTORY_MAP.get(port);
    }

    public static void populateEntries(LDAPConnection c, InputStream rs, String baseDn) throws Exception {
        LdapTestUtils.createLdapEntries(c, LdapTestUtils.readLdif(rs, baseDn), null);
    }

    public static void populateEntries(LDAPConnection c, InputStream rs, String baseDn, BindRequest bindRequest) throws Exception {
        LdapTestUtils.createLdapEntries(c, LdapTestUtils.readLdif(rs, baseDn), bindRequest);
    }

    public static void populateDefaultEntries(LDAPConnection c, String baseDn) throws Exception {
        LdapIntegrationTestsOperations.populateEntries(c, new ClassPathResource("ldif/users-groups.ldif").getInputStream(), baseDn);
    }
}

