/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import java.util.Map;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.BaseActiveDirectoryLdapAuthenticationHandlerTests;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.util.junit.EnabledIfContinuousIntegration;
import org.jooq.lambda.Unchecked;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.ldap[0].type=AUTHENTICATED", "cas.authn.ldap[0].bindDn=Administrator@cas.example.org", "cas.authn.ldap[0].bindCredential=M3110nM3110n#1", "cas.authn.ldap[0].ldapUrl=ldap://localhost:10390", "cas.authn.ldap[0].useSsl=false", "cas.authn.ldap[0].useStartTls=true", "cas.authn.ldap[0].subtreeSearch=true", "cas.authn.ldap[0].baseDn=dc=cas,dc=example,dc=org", "cas.authn.ldap[0].followReferrals=false", "cas.authn.ldap[0].principalAttributeList=sAMAccountName,cn", "cas.authn.ldap[0].enhanceWithEntryResolver=true", "cas.authn.ldap[0].searchFilter=(sAMAccountName={user})", "cas.authn.ldap[0].minPoolSize=0", "cas.authn.ldap[0].providerClass=org.ldaptive.provider.jndi.JndiProvider", "cas.authn.ldap[0].trustStore=file:/tmp/adcacerts.jks", "cas.authn.ldap[0].trustStoreType=JKS", "cas.authn.ldap[0].trustStorePassword=changeit", "cas.authn.ldap[0].hostnameVerifier=DEFAULT", "cas.authn.ldap[0].passwordPolicy.type=AD", "cas.authn.ldap[0].passwordPolicy.enabled=true"})
@EnabledIfContinuousIntegration
public class ActiveDirectoryLdapAuthenticationHandlerPasswordPolicyTests
extends BaseActiveDirectoryLdapAuthenticationHandlerTests {
    @Override
    protected String getUsername() {
        return "expirestomorrow";
    }

    @Test
    public void verifyAuthenticateWarnings() {
        Assertions.assertNotEquals((int)this.handler.size(), (int)0);
        this.handler.forEach(Unchecked.consumer(h -> {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(this.getUsername(), this.getSuccessPassword());
            AuthenticationHandlerExecutionResult result = h.authenticate((Credential)credential);
            Assertions.assertTrue((result.getWarnings() != null && result.getWarnings().size() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)result.getWarnings().stream().anyMatch(messageDescriptor -> messageDescriptor.getCode().equals("password.expiration.warning")));
            Assertions.assertNotNull((Object)result.getPrincipal());
            Assertions.assertEquals((Object)credential.getUsername(), (Object)result.getPrincipal().getId());
            Map attributes = result.getPrincipal().getAttributes();
            Arrays.stream(this.getPrincipalAttributes()).forEach(s -> Assertions.assertTrue((boolean)attributes.containsKey(s)));
        }));
    }
}

