/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import javax.security.auth.login.AccountNotFoundException;
import org.apereo.cas.authentication.BaseLdapAuthenticationHandlerTests;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.util.junit.EnabledIfContinuousIntegration;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.UncheckedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.ldap[0].type=AUTHENTICATED", "cas.authn.ldap[0].poolPassivator=CLOSE", "cas.authn.ldap[0].ldapUrl=ldap://localhost:10389", "cas.authn.ldap[0].useSsl=false", "cas.authn.ldap[0].baseDn=dc=example,dc=org", "cas.authn.ldap[0].searchFilter=cn={user}", "cas.authn.ldap[0].bindDn=cn=Directory Manager", "cas.authn.ldap[0].bindCredential=password", "cas.authn.ldap[0].principalAttributeList=description,cn"})
@EnabledIfContinuousIntegration
public class AuthenticatedLdapAuthenticationHandlerTests
extends BaseLdapAuthenticationHandlerTests {
    @Test
    public void verifyAuthenticateNotFound() {
        org.apereo.cas.util.junit.Assertions.assertThrowsWithRootCause(UncheckedException.class, AccountNotFoundException.class, () -> this.handler.forEach(Unchecked.consumer(h -> h.authenticate((Credential)new UsernamePasswordCredential("notfound", "badpassword")))));
    }

    @Test
    public void verifyAuthenticateFailureNotFound() {
        Assertions.assertNotEquals((int)this.handler.size(), (int)0);
        org.apereo.cas.util.junit.Assertions.assertThrowsWithRootCause(UncheckedException.class, AccountNotFoundException.class, () -> this.handler.forEach(Unchecked.consumer(h -> h.authenticate((Credential)new UsernamePasswordCredential("bad", "bad")))));
    }
}

