/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationTransaction;
import org.apereo.cas.authentication.LdapPasswordSynchronizationAuthenticationPostProcessor;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.util.junit.EnabledIfContinuousIntegration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.ldaptive.LdapAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class}, properties={"cas.authn.passwordSync.ldap[0].ldapUrl=ldap://localhost:10389", "cas.authn.passwordSync.ldap[0].useSsl=false", "cas.authn.passwordSync.ldap[0].baseDn=dc=example,dc=org", "cas.authn.passwordSync.ldap[0].searchFilter=cn={user}", "cas.authn.passwordSync.ldap[0].bindDn=cn=Directory Manager", "cas.authn.passwordSync.ldap[0].bindCredential=password"})
@Tag(value="Ldap")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnabledIfContinuousIntegration
public class LdapPasswordSynchronizationAuthenticationPostProcessorTests {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Test
    public void verifyOperation() {
        LdapPasswordSynchronizationAuthenticationPostProcessor sync = new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)this.casProperties.getAuthn().getPasswordSync().getLdap().get(0)){

            protected LdapAttribute getLdapPasswordAttribute(UsernamePasswordCredential credential) {
                return new LdapAttribute("st", new String[]{credential.getPassword()});
            }
        };
        UsernamePasswordCredential credentials = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"admin", (String)"password");
        Assertions.assertTrue((boolean)sync.supports((Credential)credentials));
        sync.process(CoreAuthenticationTestUtils.getAuthenticationBuilder(), (AuthenticationTransaction)DefaultAuthenticationTransaction.of((Credential[])new Credential[]{credentials}));
    }
}

