/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.resolvers.ChainingPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.EchoingPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.util.junit.EnabledIfContinuousIntegration;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(classes={CasPersonDirectoryConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.authn.attributeRepository.ldap[0].baseDn=dc=example,dc=org", "cas.authn.attributeRepository.ldap[0].ldapUrl=ldap://localhost:10389", "cas.authn.attributeRepository.ldap[0].searchFilter=cn={user}", "cas.authn.attributeRepository.ldap[0].useSsl=false", "cas.authn.attributeRepository.ldap[0].attributes.cn=cn", "cas.authn.attributeRepository.ldap[0].attributes.description=description", "cas.authn.attributeRepository.ldap[0].bindDn=cn=Directory Manager", "cas.authn.attributeRepository.ldap[0].bindCredential=password"})
@DirtiesContext
@Tag(value="Ldap")
@EnabledIfContinuousIntegration
public class PersonDirectoryPrincipalResolverLdaptiveTests {
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;

    @Test
    public void verifyResolver() {
        PersonDirectoryPrincipalResolver resolver = new PersonDirectoryPrincipalResolver(this.attributeRepository);
        Principal p = resolver.resolve((Credential)new UsernamePasswordCredential("admin", "password"), Optional.of(CoreAuthenticationTestUtils.getPrincipal()), Optional.of(new SimpleTestUsernamePasswordAuthenticationHandler()));
        Assertions.assertNotNull((Object)p);
        Assertions.assertTrue((boolean)p.getAttributes().containsKey("description"));
    }

    @Test
    public void verifyChainedResolver() {
        PersonDirectoryPrincipalResolver resolver = new PersonDirectoryPrincipalResolver(this.attributeRepository);
        ChainingPrincipalResolver chain = new ChainingPrincipalResolver();
        chain.setChain(Arrays.asList(new EchoingPrincipalResolver(), resolver));
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(2);
        attributes.put("a1", List.of("v1"));
        attributes.put("a2", List.of("v2"));
        Principal p = chain.resolve((Credential)new UsernamePasswordCredential("admin", "password"), Optional.of(CoreAuthenticationTestUtils.getPrincipal((String)"admin", attributes)), Optional.of(new SimpleTestUsernamePasswordAuthenticationHandler()));
        Assertions.assertNotNull((Object)p);
        Assertions.assertTrue((boolean)p.getAttributes().containsKey("cn"));
        Assertions.assertTrue((boolean)p.getAttributes().containsKey("a1"));
        Assertions.assertTrue((boolean)p.getAttributes().containsKey("a2"));
    }
}

