/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.io.LdifReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapTestUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapTestUtils.class);
    private static final String BASE_DN_PLACEHOLDER = "${ldapBaseDn}";
    private static final String NEWLINE = System.getProperty("line.separator");

    public static Collection<LdapEntry> readLdif(InputStream ldif, String baseDn) throws IOException {
        String ldapString = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ldif, StandardCharsets.UTF_8));){
            ldapString = reader.lines().map(line -> {
                if (line.contains(BASE_DN_PLACEHOLDER)) {
                    return line.replace(BASE_DN_PLACEHOLDER, baseDn);
                }
                return line;
            }).collect(Collectors.joining(NEWLINE));
        }
        return new LdifReader((Reader)new StringReader(ldapString)).read().getEntries();
    }

    public static void createLdapEntries(LDAPConnection connection, Collection<LdapEntry> entries) {
        LdapTestUtils.createLdapEntries(connection, entries, null);
    }

    public static void createLdapEntries(LDAPConnection connection, Collection<LdapEntry> entries, BindRequest bindRequest) {
        try {
            for (LdapEntry entry : entries) {
                ArrayList attrs = new ArrayList(entry.getAttributeNames().length);
                attrs.addAll(entry.getAttributes().stream().map(a -> new Attribute(a.getName(), a.getStringValues())).collect(Collectors.toList()));
                AddRequest ad = new AddRequest(entry.getDn(), attrs);
                LOGGER.debug("Creating entry [{}] with attributes [{}]", (Object)entry, attrs);
                connection.add(ad);
            }
        }
        catch (LDAPException e) {
            if (e.getResultCode().equals((Object)ResultCode.ENTRY_ALREADY_EXISTS)) {
                LdapTestUtils.modifyLdapEntries(connection, entries, bindRequest);
            } else {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void modifyLdapEntries(LDAPConnection connection, Collection<LdapEntry> entries, BindRequest bindRequest) {
        entries.forEach(entry -> entry.getAttributes().forEach(ldapAttribute -> LdapTestUtils.modifyLdapEntry(connection, entry, ldapAttribute, bindRequest)));
    }

    public static void modifyLdapEntries(LDAPConnection connection, Collection<LdapEntry> entries) {
        LdapTestUtils.modifyLdapEntries(connection, entries, null);
    }

    public static void modifyLdapEntry(LDAPConnection serverCon, String dn, LdapAttribute attr, AttributeModificationType add, BindRequest bindRequest) {
        String address = "ldap://" + serverCon.getConnectedAddress() + ":" + serverCon.getConnectedPort();
        try (Connection conn = DefaultConnectionFactory.getConnection((String)address);){
            try {
                if (bindRequest != null) {
                    conn.open(bindRequest);
                } else {
                    conn.open();
                }
                ModifyOperation modify = new ModifyOperation(conn);
                modify.execute((Request)new ModifyRequest(dn, new AttributeModification[]{new AttributeModification(add, attr)}));
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void modifyLdapEntry(LDAPConnection serverCon, LdapEntry dn, LdapAttribute attr, BindRequest bindRequest) {
        LdapTestUtils.modifyLdapEntry(serverCon, dn.getDn(), attr, AttributeModificationType.ADD, bindRequest);
    }

    public static void modifyLdapEntry(LDAPConnection serverCon, LdapEntry dn, LdapAttribute attr) {
        LdapTestUtils.modifyLdapEntry(serverCon, dn.getDn(), attr, AttributeModificationType.ADD, null);
    }

    @Generated
    private LdapTestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

