/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.ldap.uboundid;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.util.LdapTestUtils;
import org.ldaptive.LdapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.ClassPathResource;

public class InMemoryTestLdapDirectoryServer
implements AutoCloseable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryTestLdapDirectoryServer.class);
    private final InMemoryDirectoryServer directoryServer;
    private Collection<LdapEntry> ldapEntries;

    public InMemoryTestLdapDirectoryServer(InputStream properties, InputStream ldifFile, InputStream schemaFile, int port) {
        LOGGER.debug("Loading properties...");
        Properties p = new Properties();
        p.load(properties);
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{p.getProperty("ldap.rootDn")});
        config.addAdditionalBindCredentials(p.getProperty("ldap.managerDn"), p.getProperty("ldap.managerPassword"));
        LOGGER.debug("Loading keystore file...");
        File keystoreFile = File.createTempFile("key", "store");
        try (FileOutputStream outputStream = new FileOutputStream(keystoreFile);){
            IOUtils.copy((InputStream)new ClassPathResource("/ldapServerTrustStore").getInputStream(), (OutputStream)outputStream);
        }
        String serverKeyStorePath = keystoreFile.getCanonicalPath();
        SSLUtil serverSSLUtil = new SSLUtil((KeyManager)new KeyStoreKeyManager(serverKeyStorePath, "changeit".toCharArray()), (TrustManager)new TrustStoreTrustManager(serverKeyStorePath));
        SSLUtil clientSSLUtil = new SSLUtil((TrustManager)new TrustStoreTrustManager(serverKeyStorePath));
        LOGGER.debug("Loading LDAP listeners and ports...");
        config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"LDAP", null, (int)port, (SSLSocketFactory)serverSSLUtil.createSSLSocketFactory()), InMemoryListenerConfig.createLDAPSConfig((String)"LDAPS", null, (int)0, (SSLServerSocketFactory)serverSSLUtil.createSSLServerSocketFactory(), (SSLSocketFactory)clientSSLUtil.createSSLSocketFactory())});
        config.setEnforceSingleStructuralObjectClass(false);
        config.setEnforceAttributeSyntaxCompliance(true);
        config.setMaxConnections(-1);
        LOGGER.debug("Loading LDAP schema...");
        File file = File.createTempFile("ldap", "schema");
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)schemaFile, (OutputStream)outputStream);
        }
        LOGGER.debug("Setting LDAP schema...");
        Schema s = Schema.mergeSchemas((Schema[])new Schema[]{Schema.getSchema((File[])new File[]{file})});
        config.setSchema(s);
        this.directoryServer = new InMemoryDirectoryServer(config);
        LOGGER.debug("Populating directory...");
        LOGGER.debug("Loading LDIF file...");
        File ldif = File.createTempFile("ldiff", "file");
        try (FileOutputStream outputStream = new FileOutputStream(ldif);){
            IOUtils.copy((InputStream)ldifFile, (OutputStream)outputStream);
        }
        LOGGER.debug("Importing LDIF file...");
        this.directoryServer.importFromLDIF(true, ldif.getCanonicalPath());
        int retryCount = 5;
        while (retryCount > 0) {
            try {
                LOGGER.debug("Trying to restart LDAP server: attempt [{}]", (Object)retryCount);
                this.directoryServer.restartServer();
                try (LDAPConnection c = this.getConnection();){
                    LOGGER.debug("Connected to [{}]:[{}]", (Object)c.getConnectedAddress(), (Object)c.getConnectedPort());
                    this.populateDefaultEntries(c);
                }
                retryCount = 0;
            }
            catch (Exception e) {
                --retryCount;
            }
        }
    }

    private void populateDefaultEntries(LDAPConnection c) throws Exception {
        this.populateEntries(c, new ClassPathResource("ldif/users-groups.ldif").getInputStream());
    }

    public void populateEntries(InputStream rs) throws Exception {
        try (LDAPConnection connection = this.getConnection();){
            this.populateEntries(connection, rs);
        }
    }

    protected void populateEntries(LDAPConnection c, InputStream rs) throws Exception {
        this.ldapEntries = LdapTestUtils.readLdif(rs, this.getBaseDn());
        LdapTestUtils.createLdapEntries(c, this.ldapEntries);
        this.populateEntriesInternal(c);
    }

    protected void populateEntriesInternal(LDAPConnection c) {
    }

    public String getBaseDn() {
        return ((DN)this.directoryServer.getBaseDNs().get(0)).toNormalizedString();
    }

    public Collection<LdapEntry> getLdapEntries() {
        return this.ldapEntries;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.directoryServer.getConnection();
    }

    @Override
    public void close() {
        LOGGER.debug("Shutting down LDAP server...");
        this.directoryServer.closeAllConnections(true);
        this.directoryServer.shutDown(true);
        LOGGER.debug("Shut down LDAP server.");
    }

    public void destroy() {
        this.close();
    }

    public boolean isAlive() {
        try {
            return this.getConnection() != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

