/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.ldaptive.ad.UnicodePwdAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPasswordSynchronizationAuthenticationPostProcessor
implements AuthenticationPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordSynchronizationAuthenticationPostProcessor.class);
    private final ConnectionFactory searchFactory;
    private final AbstractLdapSearchProperties ldapProperties;

    public LdapPasswordSynchronizationAuthenticationPostProcessor(AbstractLdapSearchProperties properties) {
        this.ldapProperties = properties;
        this.searchFactory = LdapUtils.newLdaptivePooledConnectionFactory((AbstractLdapProperties)properties);
    }

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws AuthenticationException {
        block12: {
            Optional primaryCredential = transaction.getPrimaryCredential();
            if (primaryCredential.isEmpty()) {
                LOGGER.warn("Current authentication transaction does not have a primary credential");
                return;
            }
            try {
                UsernamePasswordCredential credential = (UsernamePasswordCredential)UsernamePasswordCredential.class.cast(primaryCredential.get());
                SearchFilter filter = LdapUtils.newLdaptiveSearchFilter((String)this.ldapProperties.getSearchFilter(), (String)"user", Collections.singletonList(credential.getUsername()));
                LOGGER.trace("Constructed LDAP filter [{}] to locate user and update password", (Object)filter);
                Response response = LdapUtils.executeSearchOperation((ConnectionFactory)this.searchFactory, (String)this.ldapProperties.getBaseDn(), (SearchFilter)filter, (int)this.ldapProperties.getPageSize());
                LOGGER.debug("LDAP response is [{}]", (Object)response);
                if (LdapUtils.containsResultEntry((Response)response)) {
                    SearchResult searchResult = (SearchResult)response.getResult();
                    String dn = searchResult.getEntry().getDn();
                    LOGGER.trace("Updating account password for [{}]", (Object)dn);
                    try (Connection modifyConnection = LdapUtils.createConnection((ConnectionFactory)this.searchFactory);){
                        boolean result;
                        ModifyOperation operation = new ModifyOperation(modifyConnection);
                        AttributeModification mod = new AttributeModification(AttributeModificationType.REPLACE, this.getLdapPasswordAttribute(credential));
                        Response updateResponse = operation.execute((Request)new ModifyRequest(dn, new AttributeModification[]{mod}));
                        LOGGER.trace("Result code [{}], message: [{}]", (Object)searchResult, (Object)response.getMessage());
                        boolean bl = result = updateResponse.getResultCode() == ResultCode.SUCCESS;
                        if (result) {
                            LOGGER.info("Updated the LDAP entry's password for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
                        } else {
                            LOGGER.warn("Could not update the LDAP entry's password for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
                        }
                        break block12;
                    }
                }
                LOGGER.error("Could not locate an LDAP entry for [{}] and base DN [{}]", (Object)filter.format(), (Object)this.ldapProperties.getBaseDn());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    protected LdapAttribute getLdapPasswordAttribute(UsernamePasswordCredential credential) {
        return new UnicodePwdAttribute(new String[]{credential.getPassword()});
    }
}

