/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.LdapPasswordSynchronizationAuthenticationPostProcessor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.passwordsync.LdapPasswordSynchronizationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="ldapPasswordSynchronizationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class LdapPasswordSynchronizationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordSynchronizationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            List ldap = this.casProperties.getAuthn().getPasswordSync().getLdap();
            ldap.stream().filter(LdapPasswordSynchronizationProperties::isEnabled).forEach(instance -> plan.registerAuthenticationPostProcessor((AuthenticationPostProcessor)new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)instance)));
        };
    }
}

