/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import java.util.Map;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.BaseActiveDirectoryLdapAuthenticationHandlerTests;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.jooq.lambda.Unchecked;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.ldap[0].type=AUTHENTICATED", "cas.authn.ldap[0].bind-dn=Administrator@cas.example.org", "cas.authn.ldap[0].bind-credential=M3110nM3110n#1", "cas.authn.ldap[0].ldap-url=ldap://localhost:10390", "cas.authn.ldap[0].use-start-tls=true", "cas.authn.ldap[0].subtree-search=true", "cas.authn.ldap[0].base-dn=dc=cas,dc=example,dc=org", "cas.authn.ldap[0].follow-referrals=false", "cas.authn.ldap[0].principal-attribute-list=sAMAccountName,cn", "cas.authn.ldap[0].enhance-with-entry-resolver=true", "cas.authn.ldap[0].search-filter=(sAMAccountName={user})", "cas.authn.ldap[0].min-pool-size=0", "cas.authn.ldap[0].trust-store=file:/tmp/adcacerts.jks", "cas.authn.ldap[0].trust-store-type=JKS", "cas.authn.ldap[0].trust-store-password=changeit", "cas.authn.ldap[0].hostname-verifier=DEFAULT", "cas.authn.ldap[0].password-policy.type=AD", "cas.authn.ldap[0].password-policy.enabled=true"})
@EnabledIfPortOpen(port={10390})
@Tag(value="Ldap")
public class ActiveDirectoryLdapAuthenticationHandlerPasswordPolicyTests
extends BaseActiveDirectoryLdapAuthenticationHandlerTests {
    @Override
    protected String getUsername() {
        return "expirestomorrow";
    }

    @Test
    public void verifyAuthenticateWarnings() {
        Assertions.assertNotEquals((int)this.ldapAuthenticationHandlers.size(), (int)0);
        this.ldapAuthenticationHandlers.forEach(Unchecked.consumer(h -> {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(this.getUsername(), this.getSuccessPassword());
            AuthenticationHandlerExecutionResult result = h.authenticate((Credential)credential);
            Assertions.assertTrue((result.getWarnings() != null && !result.getWarnings().isEmpty() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)result.getWarnings().stream().anyMatch(messageDescriptor -> messageDescriptor.getCode().equals("password.expiration.warning")));
            Assertions.assertNotNull((Object)result.getPrincipal());
            Assertions.assertEquals((Object)credential.getUsername(), (Object)result.getPrincipal().getId());
            Map attributes = result.getPrincipal().getAttributes();
            Arrays.stream(this.getPrincipalAttributes()).forEach(s -> Assertions.assertTrue((boolean)attributes.containsKey(s)));
        }));
    }
}

