/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.LoginException;
import org.apereo.cas.authentication.BaseLdapAuthenticationHandlerTests;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.UncheckedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.ldap[0].type=AUTHENTICATED", "cas.authn.ldap[0].ldap-url=ldap://localhost:10389", "cas.authn.ldap[0].base-dn=dc=something,dc=example,dc=org|dc=example,dc=org", "cas.authn.ldap[0].search-filter=cn={user}", "cas.authn.ldap[0].bind-dn=cn=Directory Manager", "cas.authn.ldap[0].bind-credential=password", "cas.authn.ldap[0].collect-dn-attribute=true", "cas.authn.ldap[0].principal-attribute-list=description,cn"})
@EnabledIfPortOpen(port={10389})
@Tag(value="Ldap")
public class AuthenticatedLdapAuthenticationHandlerTests {

    @TestPropertySource(properties={"cas.authn.ldap[0].principal-attribute-id=unknown", "cas.authn.ldap[0].allow-missing-principal-attribute-value=false"})
    @Nested
    public class WithUnknownCustomPrincipalIdFailing
    extends BaseLdapAuthenticationHandlerTests {
        @Override
        public void verifyAuthenticateSuccess() {
            Assertions.assertThrows(LoginException.class, () -> super.verifyAuthenticateSuccess());
        }
    }

    @TestPropertySource(properties={"cas.authn.ldap[0].principal-attribute-id=unknown"})
    @Nested
    public class WithUnknownCustomPrincipalId
    extends BaseLdapAuthenticationHandlerTests {
    }

    @Nested
    public class WithoutCustomPrincipalId
    extends BaseLdapAuthenticationHandlerTests {
        @Test
        public void verifyAuthenticateNotFound() {
            org.apereo.cas.util.junit.Assertions.assertThrowsWithRootCause(UncheckedException.class, AccountNotFoundException.class, () -> this.ldapAuthenticationHandlers.forEach(Unchecked.consumer(h -> h.authenticate((Credential)new UsernamePasswordCredential("notfound", "badpassword")))));
        }

        @Test
        public void verifyAuthenticateFailureNotFound() {
            Assertions.assertNotEquals((int)this.ldapAuthenticationHandlers.size(), (int)0);
            org.apereo.cas.util.junit.Assertions.assertThrowsWithRootCause(UncheckedException.class, AccountNotFoundException.class, () -> this.ldapAuthenticationHandlers.forEach(Unchecked.consumer(h -> h.authenticate((Credential)new UsernamePasswordCredential("bad", "bad")))));
        }
    }
}

