/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.LdapAuthenticationConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.UncheckedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreHttpConfiguration.class, CasCoreUtilConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketsConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreWebConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreConfiguration.class, LdapAuthenticationConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public abstract class BaseLdapAuthenticationHandlerTests {
    @Autowired
    @Qualifier(value="ldapAuthenticationHandlers")
    protected Collection<AuthenticationHandler> ldapAuthenticationHandlers;

    @Test
    public void verifyAuthenticateFailure() {
        Assertions.assertNotEquals((int)this.ldapAuthenticationHandlers.size(), (int)0);
        org.apereo.cas.util.junit.Assertions.assertThrowsWithRootCause(UncheckedException.class, FailedLoginException.class, () -> this.ldapAuthenticationHandlers.forEach(Unchecked.consumer(h -> h.authenticate((Credential)new UsernamePasswordCredential(this.getUsername(), this.getFailurePassword())))));
    }

    @Test
    public void verifyAuthenticateSuccess() {
        Assertions.assertNotEquals((int)this.ldapAuthenticationHandlers.size(), (int)0);
        this.ldapAuthenticationHandlers.forEach(Unchecked.consumer(h -> {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(this.getUsername(), this.getSuccessPassword());
            AuthenticationHandlerExecutionResult result = h.authenticate((Credential)credential);
            Assertions.assertNotNull((Object)result.getPrincipal());
            Assertions.assertEquals((Object)credential.getUsername(), (Object)result.getPrincipal().getId());
            Map attributes = result.getPrincipal().getAttributes();
            Arrays.stream(this.getPrincipalAttributes()).forEach(s -> Assertions.assertTrue((boolean)attributes.containsKey(s)));
        }));
    }

    String[] getPrincipalAttributes() {
        return new String[]{"cn", "description"};
    }

    String getUsername() {
        return "admin";
    }

    String getSuccessPassword() {
        return "password";
    }

    String getFailurePassword() {
        return "bad";
    }
}

