/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Arrays;
import org.apereo.cas.authentication.DirectLdapAuthenticationHandlerTests;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.TestAuthenticationResponseHandler;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="Ldap")
public class CustomPasswordPolicyLdapAuthenticationHandlerTests {

    @TestPropertySource(properties={"cas.authn.ldap[0].password-policy.enabled=true", "cas.authn.ldap[0].password-policy.custom-policy-class=org.apereo.cas.authentication.UnknownAuthenticationResponseHandler"})
    @EnabledIfPortOpen(port={10389})
    @Nested
    public class UnknownPasswordPolicyClassTests
    extends DirectLdapAuthenticationHandlerTests {
        @Test
        public void verifyOperation() {
            Assertions.assertNotNull((Object)this.ldapAuthenticationHandlers);
            LdapAuthenticationHandler handler = (LdapAuthenticationHandler)this.ldapAuthenticationHandlers.iterator().next();
            Assertions.assertTrue((boolean)Arrays.stream(handler.getAuthenticator().getResponseHandlers()).noneMatch(r -> r.getClass().equals(TestAuthenticationResponseHandler.class)));
        }
    }

    @TestPropertySource(properties={"cas.authn.ldap[0].password-policy.enabled=true", "cas.authn.ldap[0].password-policy.custom-policy-class=org.apereo.cas.authentication.TestAuthenticationResponseHandler"})
    @EnabledIfPortOpen(port={10389})
    @Nested
    public class ValidPasswordPolicyClassTests
    extends DirectLdapAuthenticationHandlerTests {
        @Test
        public void verifyOperation() {
            Assertions.assertNotNull((Object)this.ldapAuthenticationHandlers);
            LdapAuthenticationHandler handler = (LdapAuthenticationHandler)this.ldapAuthenticationHandlers.iterator().next();
            Assertions.assertTrue((boolean)Arrays.stream(handler.getAuthenticator().getResponseHandlers()).anyMatch(r -> r.getClass().equals(TestAuthenticationResponseHandler.class)));
        }
    }
}

