/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.unboundid.ldap.sdk.LDAPConnection;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.authentication.LdapPasswordSynchronizationAuthenticationPostProcessor;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.ldaptive.LdapAttribute;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class}, properties={"cas.authn.passwordSync.ldap[0].ldap-url=ldap://localhost:10389", "cas.authn.passwordSync.ldap[0].base-dn=dc=example,dc=org", "cas.authn.passwordSync.ldap[0].search-filter=cn={user}", "cas.authn.passwordSync.ldap[0].bind-dn=cn=Directory Manager", "cas.authn.passwordSync.ldap[0].bind-credential=password"})
@Tag(value="Ldap")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnabledIfPortOpen(port={10389})
public class LdapPasswordSynchronizationAuthenticationPostProcessorTests {
    @Autowired
    private CasConfigurationProperties casProperties;

    @BeforeAll
    public static void setup() throws Exception {
        LDAPConnection localhost = new LDAPConnection("localhost", 10389, "cn=Directory Manager", "password");
        localhost.connect("localhost", 10389);
        localhost.bind("cn=Directory Manager", "password");
        LdapIntegrationTestsOperations.populateDefaultEntries((LDAPConnection)localhost, (String)"ou=people,dc=example,dc=org");
    }

    @Test
    public void verifySyncFailsWithUnicodePswd() {
        Assertions.assertDoesNotThrow(() -> {
            LdapPasswordSynchronizationAuthenticationPostProcessor sync = new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)this.casProperties.getAuthn().getPasswordSync().getLdap().get(0));
            UsernamePasswordCredential credentials = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casTest", (String)"password");
            sync.process(CoreAuthenticationTestUtils.getAuthenticationBuilder(), new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
        });
    }

    @Test
    public void verifySyncFindsNoUser() {
        Assertions.assertDoesNotThrow(() -> {
            LdapPasswordSynchronizationAuthenticationPostProcessor sync = new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)this.casProperties.getAuthn().getPasswordSync().getLdap().get(0));
            UsernamePasswordCredential credentials = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"unknown123456", (String)"password");
            sync.process(CoreAuthenticationTestUtils.getAuthenticationBuilder(), new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
            sync.destroy();
        });
    }

    @Test
    public void verifyBadCredential() {
        Assertions.assertDoesNotThrow(() -> {
            LdapPasswordSynchronizationAuthenticationPostProcessor sync = new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)this.casProperties.getAuthn().getPasswordSync().getLdap().get(0));
            Credential credentials = (Credential)Mockito.mock(Credential.class);
            Assertions.assertFalse((boolean)sync.supports(credentials));
            sync.process(CoreAuthenticationTestUtils.getAuthenticationBuilder(), new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
            sync.destroy();
        });
    }

    @Test
    public void verifyOperation() {
        LdapPasswordSynchronizationAuthenticationPostProcessor sync = this.getProcessorWithMockPasswordAttribute();
        UsernamePasswordCredential credentials = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"admin", (String)"password");
        Assertions.assertTrue((boolean)sync.supports((Credential)credentials));
        Assertions.assertDoesNotThrow(() -> {
            sync.process(CoreAuthenticationTestUtils.getAuthenticationBuilder(), new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[0]));
            sync.process(CoreAuthenticationTestUtils.getAuthenticationBuilder(), new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
        });
    }

    private LdapPasswordSynchronizationAuthenticationPostProcessor getProcessorWithMockPasswordAttribute() {
        return new LdapPasswordSynchronizationAuthenticationPostProcessor((AbstractLdapSearchProperties)this.casProperties.getAuthn().getPasswordSync().getLdap().get(0)){

            protected LdapAttribute getLdapPasswordAttribute(UsernamePasswordCredential credential) {
                return new LdapAttribute("st", new String[]{credential.getPassword()});
            }
        };
    }
}

