/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.authentication.BaseLdapAuthenticationHandlerTests;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.junit.jupiter.api.Tag;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.Credential;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.ldap[0].type=AUTHENTICATED", "cas.authn.ldap[0].ldap-url=ldap://localhost:11389", "cas.authn.ldap[0].base-dn=ou=people,dc=example,dc=org", "cas.authn.ldap[0].search-filter=cn={user}", "cas.authn.ldap[0].bind-dn=cn=admin,dc=example,dc=org", "cas.authn.ldap[0].bind-credential=P@ssw0rd", "cas.authn.ldap[0].principal-attribute-list=sn,cn,homePostalAddress:homePostalAddress;"})
@Tag(value="Ldap")
@EnabledIfPortOpen(port={11389})
public class OpenLdapAuthenticationHandlerTests
extends BaseLdapAuthenticationHandlerTests {
    @Autowired
    private CasConfigurationProperties casProperties;

    protected String getLdif(String user) {
        String baseDn = ((LdapAuthenticationProperties)this.casProperties.getAuthn().getLdap().get(0)).getBaseDn();
        return String.format("dn: cn=%s,%s%nobjectClass: top%nobjectClass: person%nobjectClass: organizationalPerson%nobjectClass: inetOrgPerson%ncn: %s%nhomePostalAddress;lang-jp: address japan%nhomePostalAddress;lang-fr: 34 rue de Seine%nuserPassword: password%nsn: %s%nuid: %s%n", user, baseDn, user, user, user);
    }

    @Override
    String[] getPrincipalAttributes() {
        return new String[]{"sn", "cn", "homePostalAddress;lang-jp", "homePostalAddress;lang-fr"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getUsername() {
        String string;
        block6: {
            BindConnectionInitializer bindInit = new BindConnectionInitializer("cn=admin,dc=example,dc=org", new Credential("P@ssw0rd"));
            LDAPConnection connection = new LDAPConnection("localhost", 11389, bindInit.getBindDn(), bindInit.getBindCredential().getString());
            try {
                String uid = UUID.randomUUID().toString();
                String ldif = this.getLdif(uid);
                ByteArrayInputStream rs = new ByteArrayInputStream(ldif.getBytes(StandardCharsets.UTF_8));
                LdapIntegrationTestsOperations.populateEntries((LDAPConnection)connection, (InputStream)rs, (String)"ou=people,dc=example,dc=org", (BindConnectionInitializer)bindInit);
                string = uid;
                if (Collections.singletonList(connection).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
                throw throwable;
            }
            connection.close();
        }
        return string;
    }
}

