/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.LdapPasswordSynchronizationConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreLogoutConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreHttpConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreWebConfiguration.class, CasCoreUtilConfiguration.class, LdapPasswordSynchronizationConfiguration.class}, properties={"cas.authn.password-sync.ldap[0].ldap-url=ldap://localhost:10389", "cas.authn.password-sync.ldap[0].base-dn=dc=example,dc=org", "cas.authn.password-sync.ldap[0].search-filter=cn={user}", "cas.authn.password-sync.ldap[0].bind-dn=cn=Directory Manager", "cas.authn.password-sync.ldap[0].bind-credential=password", "cas.authn.password-sync.ldap[0].enabled=true"})
@Tag(value="Ldap")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnabledIfPortOpen(port={10389})
public class LdapPasswordSynchronizationConfigurationTests {
    @Autowired
    @Qualifier(value="authenticationEventExecutionPlan")
    private AuthenticationEventExecutionPlan authenticationEventExecutionPlan;

    @Test
    public void verifyOperation() {
        AuthenticationTransaction transaction = new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword()});
        Assertions.assertFalse((boolean)this.authenticationEventExecutionPlan.getAuthenticationPostProcessors(transaction).isEmpty());
    }
}

