/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.monitor.SystemMonitorHealthIndicator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, MetricsEndpointAutoConfiguration.class, RefreshAutoConfiguration.class, AopAutoConfiguration.class}, properties={"management.endpoint.metrics.enabled=true", "management.endpoints.web.exposure.include=*", "management.metrics.export.simple.enabled=true", "management.endpoint.health.enabled=true"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Metrics")
public class SystemMonitorHealthIndicatorTests {
    @Autowired
    @Qualifier(value="metricsEndpoint")
    private ObjectProvider<MetricsEndpoint> metricsEndpoint;

    @Test
    public void verifyObserveOk() {
        SystemMonitorHealthIndicator monitor = new SystemMonitorHealthIndicator(this.metricsEndpoint, 10);
        Status status = monitor.health().getStatus();
        Assertions.assertEquals((Object)Status.UP, (Object)status);
    }
}

