/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import java.io.StringWriter;
import java.io.Writer;
import lombok.Generated;
import org.apereo.cas.monitor.CacheStatistics;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbCacheStatistics
implements CacheStatistics {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbCacheStatistics.class);
    private final DBCollection collection;
    private final CommandResult statistics;

    public MongoDbCacheStatistics(DBCollection collection) {
        this.collection = collection;
        this.statistics = collection.getStats();
    }

    public long getSize() {
        return this.statistics.getLong("size");
    }

    public long getCapacity() {
        return this.statistics.getLong("storageSize");
    }

    public long getPercentFree() {
        return this.getCapacity() - this.statistics.getLong("totalIndexSize");
    }

    public String getName() {
        return this.collection.getName();
    }

    public String toString(StringBuilder builder) {
        try {
            JsonValue json = JsonValue.readJSON((String)this.statistics.toString());
            StringWriter writer = new StringWriter();
            json.writeTo((Writer)writer, Stringify.FORMATTED);
            builder.append(writer.toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return builder.toString();
    }

    @Generated
    public String toString() {
        return "MongoDbCacheStatistics(collection=" + this.collection + ", statistics=" + this.statistics + ")";
    }
}

