/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import com.mongodb.DBCollection;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.monitor.AbstractCacheHealthIndicator;
import org.apereo.cas.monitor.CacheStatistics;
import org.apereo.cas.monitor.MongoDbCacheStatistics;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDbHealthIndicator
extends AbstractCacheHealthIndicator {
    private final transient MongoTemplate mongoTemplate;

    public MongoDbHealthIndicator(MongoTemplate mongoTemplate, long evictionThreshold, long threshold) {
        super(evictionThreshold, threshold);
        this.mongoTemplate = mongoTemplate;
    }

    protected CacheStatistics[] getStatistics() {
        List list = this.mongoTemplate.getCollectionNames().stream().map(c -> {
            DBCollection col = this.mongoTemplate.getMongoDbFactory().getLegacyDb().getCollection(c);
            return new MongoDbCacheStatistics(col);
        }).collect(Collectors.toList());
        return (CacheStatistics[])list.toArray(CacheStatistics[]::new);
    }
}

