/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.monitor.MongoDbHealthIndicator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="mongoDbMonitoringConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class MongoDbMonitoringConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public MongoTemplate mongoHealthIndicatorTemplate() {
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        MonitorProperties.MongoDb mongoProps = this.casProperties.getMonitor().getMongo();
        return factory.buildMongoTemplate((BaseMongoDbProperties)mongoProps);
    }

    @Bean
    @RefreshScope
    public HealthIndicator mongoHealthIndicator() {
        return new MongoDbHealthIndicator(this.mongoHealthIndicatorTemplate(), this.casProperties.getMonitor().getWarn().getEvictionThreshold(), this.casProperties.getMonitor().getWarn().getThreshold());
    }
}

