/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.config.CasMongoAuthenticationConfiguration;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.MongoDbAuthenticationProperties;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.bson.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootTest(classes={CasMongoAuthenticationConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreUtilConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreHttpConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreWebConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.authn.mongo.client-uri=mongodb://root:secret@localhost:27017/admin", "cas.authn.mongo.collection=users", "cas.authn.mongo.database-name=cas", "cas.authn.mongo.attributes=loc,state", "cas.authn.mongo.username-attribute=username", "cas.authn.mongo.password-attribute=password"})
@EnableScheduling
@EnabledIfListeningOnPort(port={27017})
@Tag(value="MongoDb")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class MongoDbAuthenticationHandlerTests {
    @Autowired
    @Qualifier(value="mongoAuthenticationHandler")
    private AuthenticationHandler authenticationHandler;
    @Autowired
    private CasConfigurationProperties casProperties;

    @BeforeEach
    public void initialize() {
        MongoDbAuthenticationProperties mongo = this.casProperties.getAuthn().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        try (MongoClient mongoClient = factory.buildMongoDbClient((BaseMongoDbProperties)mongo);){
            MongoDatabase database = mongoClient.getDatabase(mongo.getDatabaseName());
            database.drop();
            MongoCollection col = database.getCollection(mongo.getCollection());
            Document account = new Document();
            account.append(mongo.getUsernameAttribute(), (Object)"u1");
            account.append(mongo.getPasswordAttribute(), (Object)"p1");
            account.append("loc", (Object)"Apereo");
            account.append("state", (Object)"California");
            col.insertOne((Object)account);
            account = new Document();
            account.append(mongo.getUsernameAttribute(), (Object)"userPlain");
            col.insertOne((Object)account);
        }
    }

    @Test
    public void verifyAuthentication() throws Exception {
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"u1", (String)"p1");
        AuthenticationHandlerExecutionResult result = this.authenticationHandler.authenticate((Credential)creds, (Service)Mockito.mock(Service.class));
        Assertions.assertEquals((Object)"u1", (Object)result.getPrincipal().getId());
        Map attributes = result.getPrincipal().getAttributes();
        Assertions.assertTrue((boolean)attributes.containsKey("loc"));
        Assertions.assertTrue((boolean)attributes.containsKey("state"));
    }

    @Test
    public void verifyAuthenticationFails() {
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"unknown", (String)"p1");
        Assertions.assertThrows(AccountNotFoundException.class, () -> this.authenticationHandler.authenticate((Credential)creds, (Service)Mockito.mock(Service.class)));
    }

    @Test
    public void verifyNoPsw() {
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"userPlain", (String)"p1");
        Assertions.assertThrows(FailedLoginException.class, () -> this.authenticationHandler.authenticate((Credential)creds, (Service)Mockito.mock(Service.class)));
    }

    @Test
    public void verifyBadPsw() {
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"u1", (String)"other");
        Assertions.assertThrows(FailedLoginException.class, () -> this.authenticationHandler.authenticate((Credential)creds, (Service)Mockito.mock(Service.class)));
    }
}

