/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.mongodb.client.MongoClient;
import java.util.Collection;
import java.util.List;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.SingleCollectionMongoDbProperties;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mongodb.config.StringToWriteConcernConverter;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.Document;

@EnabledIfListeningOnPort(port={27017})
@Tag(value="MongoDb")
public class MongoDbConnectionFactoryTests {
    private static final String URI = "mongodb://root:secret@localhost:27017/admin";

    @Test
    public void verifyProps() {
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        SingleCollectionMongoDbProperties props = new SingleCollectionMongoDbProperties();
        props.setClientUri(URI);
        CasMongoOperations template = factory.buildMongoTemplate((BaseMongoDbProperties)props);
        Assertions.assertNotNull((Object)template);
        MongoDbConnectionFactory.createCollection((MongoOperations)template, (String)this.getClass().getSimpleName(), (boolean)true);
    }

    @Test
    public void verifyClient() {
        SingleCollectionMongoDbProperties props = new SingleCollectionMongoDbProperties();
        props.setClientUri(URI);
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        MongoClient client = factory.buildMongoDbClient((BaseMongoDbProperties)props);
        Assertions.assertNotNull((Object)client);
    }

    @Test
    public void verifyPackages() {
        SingleCollectionMongoDbProperties props = new SingleCollectionMongoDbProperties();
        props.setHost("localhost,localhost");
        props.setPort(27017);
        props.setUserId("root");
        props.setPassword("password");
        props.setDatabaseName("audit");
        props.setAuthenticationDatabaseName("admin");
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(new Converter[]{new StringToWriteConcernConverter()}){

            protected Collection<String> getMappingBasePackages() {
                return List.of(SampleDocument.class.getPackageName());
            }
        };
        CasMongoOperations template = factory.buildMongoTemplate((BaseMongoDbProperties)props);
        Assertions.assertNotNull((Object)template);
    }

    @Document
    public static class SampleDocument {
    }
}

