/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.spi.config.CasCoreAuditConfiguration;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.metadata.BasicCredentialMetaData;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketComponentSerializationConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreUtilSerializationConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasOAuth20AuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasOAuth20ComponentSerializationConfiguration;
import org.apereo.cas.config.CasOAuth20Configuration;
import org.apereo.cas.config.CasOAuth20EndpointsConfiguration;
import org.apereo.cas.config.CasOAuth20ServicesConfiguration;
import org.apereo.cas.config.CasOAuth20ThrottleConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.CasThrottlingConfiguration;
import org.apereo.cas.config.CasThymeleafConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.mock.MockServiceTicket;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.CasOAuth20TestAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20DeviceUserCodeApprovalEndpointController;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.expiration.AlwaysExpiresExpirationPolicy;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.ComponentSerializationPlan;
import org.apereo.cas.util.serialization.ComponentSerializationPlanConfigurer;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@SpringBootTest(classes={SharedTestConfiguration.class}, properties={"cas.authn.attribute-repository.stub.attributes.uid=cas", "cas.authn.attribute-repository.stub.attributes.givenName=apereo-cas", "spring.main.allow-bean-definition-overriding=true"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@EnableAspectJAutoProxy(proxyTargetClass=false)
public abstract class AbstractOAuth20Tests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOAuth20Tests.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules().configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, true);
    public static final String CONTEXT = "/oauth2.0/";
    public static final String CLIENT_ID = "1";
    public static final String CLIENT_SECRET = "secret";
    public static final String WRONG_CLIENT_SECRET = "wrongSecret";
    public static final String REDIRECT_URI = "http://someurl";
    public static final String OTHER_REDIRECT_URI = "http://someotherurl";
    public static final String SERVICE_URL = "http://serviceurl";
    public static final String ID = "casuser";
    public static final String NAME = "attributeName";
    public static final String ATTRIBUTES_PARAM = "attributes";
    public static final String NAME2 = "attributeName2";
    public static final String VALUE = "attributeValue";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String GOOD_USERNAME = "test";
    public static final String GOOD_PASSWORD = "test";
    public static final String CODE_CHALLENGE = "myclientcode";
    public static final String CODE_CHALLENGE_METHOD_PLAIN = "plain";
    public static final String FIRST_NAME_ATTRIBUTE = "firstName";
    public static final String FIRST_NAME = "jerome";
    public static final String LAST_NAME_ATTRIBUTE = "lastName";
    public static final String LAST_NAME = "LELEU";
    public static final String CAS_SERVER = "casserver";
    public static final String CAS_SCHEME = "https";
    public static final int CAS_PORT = 443;
    public static final int DELTA = 2;
    public static final int TIMEOUT = 7200;
    @Autowired
    @Qualifier(value="oauthCasClient")
    protected Client oauthCasClient;
    @Autowired
    @Qualifier(value="oauthCasClientRedirectActionBuilder")
    protected OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    protected ServiceFactory<WebApplicationService> serviceFactory;
    @Autowired
    @Qualifier(value="oauthHandlerInterceptorAdapter")
    protected HandlerInterceptor oauthHandlerInterceptorAdapter;
    @Autowired
    @Qualifier(value="accessTokenController")
    protected OAuth20AccessTokenEndpointController accessTokenController;
    @Autowired
    @Qualifier(value="oauthDistributedSessionStore")
    protected SessionStore oauthDistributedSessionStore;
    @Autowired
    @Qualifier(value="oauthAuthorizationCodeResponseBuilder")
    protected OAuth20AuthorizationResponseBuilder oauthAuthorizationCodeResponseBuilder;
    @Autowired
    @Qualifier(value="oauthTokenResponseBuilder")
    protected OAuth20AuthorizationResponseBuilder oauthTokenResponseBuilder;
    @Autowired
    @Qualifier(value="oauth20ClientSecretValidator")
    protected OAuth20ClientSecretValidator oauth20ClientSecretValidator;
    @Autowired
    @Qualifier(value="accessTokenResponseGenerator")
    protected OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator;
    @Autowired
    @Qualifier(value="accessTokenJwtBuilder")
    protected JwtBuilder accessTokenJwtBuilder;
    @Autowired
    @Qualifier(value="deviceUserCodeApprovalEndpointController")
    protected OAuth20DeviceUserCodeApprovalEndpointController deviceController;
    @Autowired
    @Qualifier(value="oauthResourceOwnerCredentialsResponseBuilder")
    protected OAuth20AuthorizationResponseBuilder oauthResourceOwnerCredentialsResponseBuilder;
    @Autowired
    @Qualifier(value="servicesManager")
    protected ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    protected CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="requiresAuthenticationAccessTokenInterceptor")
    protected HandlerInterceptor requiresAuthenticationInterceptor;
    protected ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    protected OAuth20CodeFactory oAuthCodeFactory;
    @Autowired
    @Qualifier(value="defaultDeviceTokenFactory")
    protected OAuth20DeviceTokenFactory defaultDeviceTokenFactory;
    @Autowired
    @Qualifier(value="oauthRequestParameterResolver")
    protected OAuth20RequestParameterResolver oauthRequestParameterResolver;
    @Autowired
    @Qualifier(value="defaultDeviceUserCodeFactory")
    protected OAuth20DeviceUserCodeFactory defaultDeviceUserCodeFactory;
    @Autowired
    @Qualifier(value="defaultRefreshTokenFactory")
    protected OAuth20RefreshTokenFactory oAuthRefreshTokenFactory;
    @Autowired
    @Qualifier(value="defaultOAuthCodeFactory")
    protected OAuth20CodeFactory defaultOAuthCodeFactory;
    @Autowired
    @Qualifier(value="ticketRegistry")
    protected TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="oauthAccessTokenJwtCipherExecutor")
    protected CipherExecutor oauthAccessTokenJwtCipherExecutor;
    @Autowired
    @Qualifier(value="defaultAccessTokenFactory")
    protected OAuth20AccessTokenFactory defaultAccessTokenFactory;
    @Autowired
    @Qualifier(value="oauthTokenGenerator")
    protected OAuth20TokenGenerator oauthTokenGenerator;
    @Autowired
    @Qualifier(value="deviceTokenExpirationPolicy")
    protected ExpirationPolicyBuilder deviceTokenExpirationPolicy;
    @Autowired
    protected CasConfigurationProperties casProperties;

    public static ExpirationPolicyBuilder alwaysExpiresExpirationPolicyBuilder() {
        return new ExpirationPolicyBuilder(){
            private static final long serialVersionUID = -9043565995104313970L;

            public ExpirationPolicy buildTicketExpirationPolicy() {
                return AlwaysExpiresExpirationPolicy.INSTANCE;
            }
        };
    }

    protected static OAuth20AccessToken getAccessToken() {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(ID);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getId()).thenReturn((Object)"AT-123456");
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
        Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)tgt.getAuthentication());
        Mockito.when((Object)accessToken.getService()).thenReturn((Object)service);
        Mockito.when((Object)accessToken.getClientId()).thenReturn((Object)CLIENT_ID);
        Mockito.when((Object)accessToken.getExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        return accessToken;
    }

    protected static OAuthRegisteredService getRegisteredService(String clientId, String secret) {
        return AbstractOAuth20Tests.getRegisteredService("https://oauth.example.org", clientId, secret, Set.of());
    }

    protected static OAuthRegisteredService getRegisteredService(String serviceId, String clientId, String secret) {
        return AbstractOAuth20Tests.getRegisteredService(serviceId, clientId, secret, Set.of());
    }

    protected static OAuthRegisteredService getRegisteredService(String serviceId, String secret, Set<OAuth20GrantTypes> grantTypes) {
        return AbstractOAuth20Tests.getRegisteredService(serviceId, CLIENT_ID, secret, grantTypes);
    }

    protected static OAuthRegisteredService getRegisteredService(String serviceId, String clientId, String secret, Set<OAuth20GrantTypes> grantTypes) {
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setName("The registered service name");
        service.setServiceId(serviceId);
        service.setClientId(clientId);
        service.setClientSecret(secret);
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        service.setSupportedGrantTypes((Set)grantTypes.stream().map(OAuth20GrantTypes::getType).collect(Collectors.toCollection(HashSet::new)));
        return service;
    }

    protected static Principal createPrincipal() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put(NAME, List.of(VALUE));
        List<String> list = List.of(VALUE, VALUE);
        map.put(NAME2, list);
        return CoreAuthenticationTestUtils.getPrincipal((String)ID, map);
    }

    protected static Authentication getAuthentication(Principal principal) {
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)new BasicIdentifiableCredential(principal.getId()));
        DefaultAuthenticationHandlerExecutionResult handlerResult = new DefaultAuthenticationHandlerExecutionResult(principal.getClass().getCanonicalName(), (CredentialMetaData)metadata, principal, new ArrayList());
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).setAuthenticationDate(ZonedDateTime.now(ZoneOffset.UTC)).addCredential((CredentialMetaData)metadata).addSuccess(principal.getClass().getCanonicalName(), (AuthenticationHandlerExecutionResult)handlerResult).build();
    }

    @BeforeEach
    public void setup() {
        this.applicationContext = new StaticApplicationContext();
        this.applicationContext.refresh();
        ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext, CasConfigurationProperties.class, (String)CasConfigurationProperties.class.getSimpleName());
        ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.applicationContext);
    }

    protected OAuthRegisteredService addRegisteredService(Set<OAuth20GrantTypes> grantTypes) {
        return this.addRegisteredService(false, grantTypes);
    }

    protected OAuthRegisteredService addRegisteredService(boolean generateRefreshToken, Set<OAuth20GrantTypes> grantTypes) {
        return this.addRegisteredService(generateRefreshToken, grantTypes, CLIENT_SECRET);
    }

    protected OAuthRegisteredService addRegisteredService(boolean generateRefreshToken, Set<OAuth20GrantTypes> grantTypes, String clientSecret) {
        OAuthRegisteredService registeredService = AbstractOAuth20Tests.getRegisteredService(REDIRECT_URI, clientSecret, grantTypes);
        registeredService.setGenerateRefreshToken(generateRefreshToken);
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }

    protected OAuthRegisteredService addRegisteredService(String redirectUri, String clientSecret) {
        OAuthRegisteredService registeredService = AbstractOAuth20Tests.getRegisteredService(redirectUri, clientSecret, EnumSet.allOf(OAuth20GrantTypes.class));
        registeredService.setGenerateRefreshToken(true);
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }

    protected OAuthRegisteredService addRegisteredService(Set<OAuth20GrantTypes> grantTypes, String clientSecret) {
        return this.addRegisteredService(false, grantTypes, clientSecret);
    }

    protected OAuthRegisteredService addRegisteredService() {
        return this.addRegisteredService(false, EnumSet.noneOf(OAuth20GrantTypes.class));
    }

    protected void clearAllServices() {
        this.servicesManager.deleteAll();
        this.servicesManager.load();
    }

    protected Pair<String, String> assertClientOK(OAuthRegisteredService service, boolean refreshToken) {
        return this.assertClientOK(service, refreshToken, null);
    }

    protected Pair<String, String> assertClientOK(OAuthRegisteredService service, boolean refreshToken, String scopes) {
        Principal principal = AbstractOAuth20Tests.createPrincipal();
        OAuth20Code code = this.addCode(principal, service);
        LOGGER.debug("Added code [{}] for principal [{}]", (Object)code, (Object)principal);
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("redirect_uri", REDIRECT_URI);
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.name().toLowerCase());
        String auth = "1:secret";
        String value = EncodingUtils.encodeBase64((byte[])"1:secret".getBytes(StandardCharsets.UTF_8));
        String header = "Basic " + value;
        mockRequest.addHeader("Authorization", (Object)header);
        LOGGER.debug("Created header [{}] for client id [{}]", (Object)header, (Object)CLIENT_ID);
        mockRequest.setParameter("client_id", CLIENT_ID);
        mockRequest.setParameter("client_secret", CLIENT_SECRET);
        if (StringUtils.isNotBlank((CharSequence)scopes)) {
            mockRequest.setParameter("scope", scopes);
        }
        mockRequest.setParameter("code", code.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        LOGGER.debug("Invoking authentication interceptor...");
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        LOGGER.debug("Submitting access token request...");
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertNull((Object)this.ticketRegistry.getTicket(code.getId()));
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        String refreshTokenId = "";
        Map model = mv.getModel();
        Assertions.assertTrue((boolean)model.containsKey("access_token"));
        if (refreshToken) {
            Assertions.assertTrue((boolean)model.containsKey("refresh_token"));
            refreshTokenId = model.get("refresh_token").toString();
        }
        Assertions.assertTrue((boolean)model.containsKey("expires_in"));
        String accessTokenId = this.extractAccessTokenFrom(model.get("access_token").toString());
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(accessTokenId, OAuth20AccessToken.class);
        Assertions.assertEquals((Object)principal, (Object)accessToken.getAuthentication().getPrincipal());
        int timeLeft = Integer.parseInt(model.get("expires_in").toString());
        Assertions.assertTrue((timeLeft >= 7188 ? 1 : 0) != 0);
        return Pair.of((Object)accessTokenId, (Object)refreshTokenId);
    }

    protected OAuth20Code addCode(Principal principal, OAuthRegisteredService registeredService) throws Exception {
        return this.addCodeWithChallenge(principal, registeredService, null, null);
    }

    protected OAuth20Code addCodeWithChallenge(Principal principal, OAuthRegisteredService registeredService, String codeChallenge, String codeChallengeMethod) throws Exception {
        Authentication authentication = AbstractOAuth20Tests.getAuthentication(principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getClientId());
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket(ID);
        this.ticketRegistry.addTicket((Ticket)tgt);
        OAuth20Code code = this.oAuthCodeFactory.create((Service)service, authentication, (TicketGrantingTicket)tgt, new ArrayList(), codeChallenge, codeChallengeMethod, CLIENT_ID, new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)code);
        return code;
    }

    protected String extractAccessTokenFrom(String token) {
        return (String)OAuth20JwtAccessTokenEncoder.builder().accessTokenJwtBuilder(this.accessTokenJwtBuilder).build().decode((Object)token);
    }

    protected OAuth20RefreshToken addRefreshToken(Principal principal, OAuthRegisteredService registeredService) throws Exception {
        Authentication authentication = AbstractOAuth20Tests.getAuthentication(principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getServiceId());
        OAuth20RefreshToken refreshToken = this.oAuthRefreshTokenFactory.create((Service)service, authentication, (TicketGrantingTicket)new MockTicketGrantingTicket(ID), new ArrayList(), registeredService.getClientId(), "", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)refreshToken);
        return refreshToken;
    }

    protected OAuth20RefreshToken addRefreshToken(Principal principal, OAuthRegisteredService registeredService, OAuth20AccessToken accessToken) throws Exception {
        Authentication authentication = AbstractOAuth20Tests.getAuthentication(principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getServiceId());
        OAuth20RefreshToken refreshToken = this.oAuthRefreshTokenFactory.create((Service)service, authentication, (TicketGrantingTicket)new MockTicketGrantingTicket(ID), new ArrayList(), registeredService.getClientId(), accessToken.getId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)refreshToken);
        return refreshToken;
    }

    protected OAuth20AccessToken addAccessToken(Principal principal, OAuthRegisteredService registeredService) throws Exception {
        OAuth20Code code = this.addCode(principal, registeredService);
        return this.addAccessToken(principal, registeredService, code.getId());
    }

    protected OAuth20AccessToken addAccessToken(Principal principal, OAuthRegisteredService registeredService, String codeId) throws Exception {
        Authentication authentication = AbstractOAuth20Tests.getAuthentication(principal);
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService service = factory.createService(registeredService.getServiceId());
        OAuth20AccessToken accessToken = this.defaultAccessTokenFactory.create((Service)service, authentication, (TicketGrantingTicket)new MockTicketGrantingTicket(ID), new ArrayList(), codeId, registeredService.getClientId(), new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)accessToken);
        return accessToken;
    }

    protected Pair<OAuth20AccessToken, OAuth20RefreshToken> assertRefreshTokenOk(OAuthRegisteredService service) {
        Principal principal = AbstractOAuth20Tests.createPrincipal();
        OAuth20RefreshToken refreshToken = this.addRefreshToken(principal, service);
        return this.assertRefreshTokenOk(service, refreshToken, principal);
    }

    protected Pair<OAuth20AccessToken, OAuth20RefreshToken> assertRefreshTokenOk(OAuthRegisteredService service, OAuth20RefreshToken refreshToken, Principal principal) throws Exception {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        mockRequest.setParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name().toLowerCase());
        mockRequest.setParameter("client_id", CLIENT_ID);
        mockRequest.setParameter("client_secret", CLIENT_SECRET);
        mockRequest.setParameter("refresh_token", refreshToken.getId());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.requiresAuthenticationInterceptor.preHandle((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse, null);
        ModelAndView mv = this.accessTokenController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        Assertions.assertEquals((int)200, (int)mockResponse.getStatus());
        Assertions.assertTrue((boolean)mv.getModel().containsKey("access_token"));
        if (service.isGenerateRefreshToken()) {
            Assertions.assertTrue((boolean)mv.getModel().containsKey("refresh_token"));
            if (service.isRenewRefreshToken()) {
                Assertions.assertNull((Object)this.ticketRegistry.getTicket(refreshToken.getId()));
            }
        }
        OAuth20RefreshToken newRefreshToken = service.isRenewRefreshToken() ? (OAuth20RefreshToken)this.ticketRegistry.getTicket(mv.getModel().get("refresh_token").toString(), OAuth20RefreshToken.class) : refreshToken;
        Assertions.assertTrue((boolean)mv.getModel().containsKey("expires_in"));
        String accessTokenId = mv.getModel().get("access_token").toString();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(accessTokenId, OAuth20AccessToken.class);
        Assertions.assertEquals((Object)principal, (Object)accessToken.getAuthentication().getPrincipal());
        int timeLeft = Integer.parseInt(mv.getModel().get("expires_in").toString());
        Assertions.assertTrue((timeLeft >= 7188 ? 1 : 0) != 0);
        return Pair.of((Object)accessToken, (Object)newRefreshToken);
    }

    protected ModelAndView generateAccessTokenResponseAndGetModelAndView(OAuthRegisteredService registeredService) {
        return this.generateAccessTokenResponseAndGetModelAndView(registeredService, RegisteredServiceTestUtils.getAuthentication((String)ID), OAuth20GrantTypes.AUTHORIZATION_CODE);
    }

    protected ModelAndView generateAccessTokenResponseAndGetModelAndView(OAuthRegisteredService registeredService, Authentication authentication, OAuth20GrantTypes grantType) {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HttpMethod.GET.name(), "/oauth2.0/accessToken");
        return this.generateAccessTokenResponseAndGetModelAndView(registeredService, authentication, grantType, (HttpServletRequest)mockRequest);
    }

    protected ModelAndView generateAccessTokenResponseAndGetModelAndView(OAuthRegisteredService registeredService, Authentication authentication, OAuth20GrantTypes grantType, HttpServletRequest mockRequest) {
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)SERVICE_URL);
        AccessTokenRequestContext holder = AccessTokenRequestContext.builder().clientId(registeredService.getClientId()).service((Service)service).authentication(authentication).registeredService(registeredService).grantType(grantType).responseType(OAuth20ResponseTypes.CODE).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket(ID)).claims(this.oauthRequestParameterResolver.resolveRequestClaims((WebContext)new JEEContext(mockRequest, (HttpServletResponse)mockResponse))).build();
        OAuth20TokenGeneratedResult generatedToken = this.oauthTokenGenerator.generate(holder);
        OAuth20AccessTokenResponseResult.OAuth20AccessTokenResponseResultBuilder builder = OAuth20AccessTokenResponseResult.builder();
        OAuth20AccessTokenResponseResult result = builder.registeredService((RegisteredService)registeredService).responseType(OAuth20ResponseTypes.CODE).service((Service)service).generatedToken(generatedToken).build();
        return this.accessTokenResponseGenerator.generate(result);
    }

    protected long getDefaultAccessTokenExpiration() {
        String seconds = this.casProperties.getAuthn().getOauth().getAccessToken().getMaxTimeToLiveInSeconds();
        return Beans.newDuration((String)seconds).getSeconds();
    }

    @ImportAutoConfiguration(value={RefreshAutoConfiguration.class, SecurityAutoConfiguration.class, WebMvcAutoConfiguration.class, AopAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasOAuth20TestAuthenticationEventExecutionPlanConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreHttpConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreAuditConfiguration.class, CasCoreConfiguration.class, CasCookieConfiguration.class, CasThrottlingConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketComponentSerializationConfiguration.class, CasCoreUtilSerializationConfiguration.class, CasPersonDirectoryConfiguration.class, OAuth20TestConfiguration.class, CasThymeleafConfiguration.class, CasThemesConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasCoreWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasOAuth20AuthenticationServiceSelectionStrategyConfiguration.class, CasOAuth20ComponentSerializationConfiguration.class, CasOAuth20Configuration.class, CasOAuth20ServicesConfiguration.class, CasOAuth20EndpointsConfiguration.class, CasOAuth20ThrottleConfiguration.class})
    public static class SharedTestConfiguration {
    }

    @TestConfiguration(value="OAuth20TestConfiguration", proxyBeanMethods=false)
    public static class OAuth20TestConfiguration
    implements ComponentSerializationPlanConfigurer {
        @Autowired
        protected ApplicationContext applicationContext;

        @Bean
        public List inMemoryRegisteredServices() {
            OAuthRegisteredService svc1 = (OAuthRegisteredService)RegisteredServiceTestUtils.getRegisteredService((String)"^(https?|imaps?)://.*", OAuthRegisteredService.class);
            svc1.setClientId(UUID.randomUUID().toString());
            svc1.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
            OAuthRegisteredService svc2 = (OAuthRegisteredService)RegisteredServiceTestUtils.getRegisteredService((String)"https://example.org/jwt-access-token", OAuthRegisteredService.class);
            svc2.setClientId(AbstractOAuth20Tests.CLIENT_ID);
            svc2.setJwtAccessToken(true);
            return CollectionUtils.wrapList((Object[])new OAuthRegisteredService[]{svc1, svc2});
        }

        public void configureComponentSerializationPlan(ComponentSerializationPlan plan) {
            plan.registerSerializableClass(MockTicketGrantingTicket.class);
            plan.registerSerializableClass(MockServiceTicket.class);
        }
    }
}

