/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Arrays;
import java.util.UUID;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.config.CasAuthenticationEventExecutionPlanTestConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketComponentSerializationConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreTicketsSerializationConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasOAuth20AuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasOAuth20ComponentSerializationConfiguration;
import org.apereo.cas.config.CasOAuth20Configuration;
import org.apereo.cas.config.CasOAuth20EndpointsConfiguration;
import org.apereo.cas.config.CasOAuth20ServicesConfiguration;
import org.apereo.cas.config.CasOAuth20TicketSerializationConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.annotation.EnableRetry;

@SpringBootTest(classes={SharedTestConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableRetry
public abstract class BaseOAuth20AuthenticatorTests {
    @Autowired
    @Qualifier(value="servicesManager")
    protected ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    protected CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    protected AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="oauthRequestParameterResolver")
    protected OAuth20RequestParameterResolver oauthRequestParameterResolver;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    protected ServiceFactory<WebApplicationService> serviceFactory;
    @Autowired
    @Qualifier(value="accessTokenJwtBuilder")
    protected JwtBuilder accessTokenJwtBuilder;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    protected PrincipalResolver defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="oauthClientAuthenticator")
    protected Authenticator oauthClientAuthenticator;
    @Autowired
    @Qualifier(value="oauth20ClientSecretValidator")
    protected OAuth20ClientSecretValidator oauth20ClientSecretValidator;
    protected OAuthRegisteredService service;
    protected OAuthRegisteredService serviceJwtAccessToken;
    protected OAuthRegisteredService serviceWithoutSecret;
    protected OAuthRegisteredService serviceWithoutSecret2;
    protected OAuthRegisteredService serviceWithAttributesMapping;
    @Autowired
    @Qualifier(value="ticketRegistry")
    protected TicketRegistry ticketRegistry;
    @Autowired
    protected CasConfigurationProperties casProperties;

    @BeforeEach
    public void initialize() {
        this.service = new OAuthRegisteredService();
        this.service.setName("OAuth");
        this.service.setId(1L);
        this.service.setServiceId("https://www.example.org");
        this.service.setClientSecret("secret");
        this.service.setClientId("client");
        this.serviceWithoutSecret = new OAuthRegisteredService();
        this.serviceWithoutSecret.setName("OAuth2");
        this.serviceWithoutSecret.setId(2L);
        this.serviceWithoutSecret.setServiceId("https://www.example2.org");
        this.serviceWithoutSecret.setClientId("clientWithoutSecret");
        this.serviceWithoutSecret2 = new OAuthRegisteredService();
        this.serviceWithoutSecret2.setName("OAuth3");
        this.serviceWithoutSecret2.setId(3L);
        this.serviceWithoutSecret2.setServiceId("https://www.example3org");
        this.serviceWithoutSecret2.setClientId("clientWithoutSecret2");
        this.serviceJwtAccessToken = new OAuthRegisteredService();
        this.serviceJwtAccessToken.setName("The registered service name");
        this.serviceJwtAccessToken.setServiceId("https://oauth.jwt.service");
        this.serviceJwtAccessToken.setClientId("clientid");
        this.serviceJwtAccessToken.setClientSecret("clientsecret");
        this.serviceJwtAccessToken.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        this.serviceJwtAccessToken.setJwtAccessToken(true);
        this.serviceWithAttributesMapping = new OAuthRegisteredService();
        this.serviceWithAttributesMapping.setName("OAuth5");
        this.serviceWithAttributesMapping.setId(5L);
        this.serviceWithAttributesMapping.setServiceId("https://www.example5.org");
        this.serviceWithAttributesMapping.setClientSecret("secret");
        this.serviceWithAttributesMapping.setClientId("serviceWithAttributesMapping");
        this.serviceWithAttributesMapping.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider(CaseCanonicalizationMode.LOWER.name()));
        this.serviceWithAttributesMapping.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy(Arrays.asList("eduPersonAffiliation")));
        this.servicesManager.save(new RegisteredService[]{this.service, this.serviceWithoutSecret, this.serviceWithoutSecret2, this.serviceJwtAccessToken, this.serviceWithAttributesMapping});
    }

    protected static OAuth20AccessToken getAccessToken() {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getId()).thenReturn((Object)"ABCD");
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
        Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)tgt.getAuthentication());
        Mockito.when((Object)accessToken.getService()).thenReturn((Object)service);
        Mockito.when((Object)accessToken.getExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        return accessToken;
    }

    protected static OAuth20Code getCode() {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
        OAuth20Code oauthCode = (OAuth20Code)Mockito.mock(OAuth20Code.class);
        Mockito.when((Object)oauthCode.getId()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)oauthCode.getTicketGrantingTicket()).thenReturn((Object)tgt);
        Mockito.when((Object)oauthCode.getAuthentication()).thenReturn((Object)tgt.getAuthentication());
        Mockito.when((Object)oauthCode.getService()).thenReturn((Object)service);
        Mockito.when((Object)oauthCode.getExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        return oauthCode;
    }

    protected static OAuth20RefreshToken getRefreshToken(OAuthRegisteredService service) {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        OAuth20RefreshToken refreshToken = (OAuth20RefreshToken)Mockito.mock(OAuth20RefreshToken.class);
        Mockito.when((Object)refreshToken.getId()).thenReturn((Object)"ABCD");
        Mockito.when((Object)refreshToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
        Mockito.when((Object)refreshToken.getAuthentication()).thenReturn((Object)tgt.getAuthentication());
        Mockito.when((Object)refreshToken.getClientId()).thenReturn((Object)service.getClientId());
        Mockito.when((Object)refreshToken.getExpirationPolicy()).thenReturn((Object)NeverExpiresExpirationPolicy.INSTANCE);
        return refreshToken;
    }

    @ImportAutoConfiguration(value={RefreshAutoConfiguration.class, SecurityAutoConfiguration.class, WebMvcAutoConfiguration.class, AopAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={CasCoreHttpConfiguration.class, CasCoreUtilConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketComponentSerializationConfiguration.class, CasCoreTicketsSerializationConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreWebConfiguration.class, CasCookieConfiguration.class, CasCoreConfiguration.class, CasAuthenticationEventExecutionPlanTestConfiguration.class, CasOAuth20AuthenticationServiceSelectionStrategyConfiguration.class, CasOAuth20ComponentSerializationConfiguration.class, CasOAuth20Configuration.class, CasOAuth20EndpointsConfiguration.class, CasOAuth20ServicesConfiguration.class, CasOAuth20TicketSerializationConfiguration.class})
    public static class SharedTestConfiguration {
    }
}

