/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.authenticator.BaseOAuth20AuthenticatorTests;
import org.apereo.cas.support.oauth.authenticator.OAuth20AccessTokenAuthenticator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20AccessTokenAuthenticatorTests
extends BaseOAuth20AuthenticatorTests {
    protected OAuth20AccessTokenAuthenticator authenticator;

    @BeforeEach
    public void init() {
        this.authenticator = new OAuth20AccessTokenAuthenticator(this.ticketRegistry, this.accessTokenJwtBuilder);
    }

    @Override
    @BeforeEach
    public void initialize() {
        super.initialize();
        this.ticketRegistry.deleteAll();
    }

    @Test
    public void verifyAuthenticationWithJwtAccessToken() throws Exception {
        OAuth20AccessToken accessToken = OAuth20AccessTokenAuthenticatorTests.getAccessToken();
        this.ticketRegistry.addTicket((Ticket)accessToken);
        OAuth20JwtAccessTokenEncoder encoder = OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)this.serviceJwtAccessToken).service(accessToken.getService()).accessTokenJwtBuilder(this.accessTokenJwtBuilder).casProperties(this.casProperties).build();
        TokenCredentials credentials = new TokenCredentials((String)encoder.encode((Object)accessToken.getId()));
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyAuthenticationFailsWithNoToken() {
        OAuth20AccessToken accessToken = OAuth20AccessTokenAuthenticatorTests.getAccessToken();
        OAuth20JwtAccessTokenEncoder encoder = OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)this.serviceJwtAccessToken).service(accessToken.getService()).accessTokenJwtBuilder(this.accessTokenJwtBuilder).casProperties(this.casProperties).build();
        TokenCredentials credentials = new TokenCredentials((String)encoder.encode((Object)accessToken.getId()));
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(InvalidTicketException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAuthentication() throws Exception {
        OAuth20AccessToken accessToken = OAuth20AccessTokenAuthenticatorTests.getAccessToken();
        this.ticketRegistry.addTicket((Ticket)accessToken);
        OAuth20JwtAccessTokenEncoder encoder = OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)this.service).service(accessToken.getService()).accessTokenJwtBuilder(this.accessTokenJwtBuilder).casProperties(this.casProperties).build();
        TokenCredentials credentials = new TokenCredentials((String)encoder.encode((Object)accessToken.getId()));
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
    }
}

