/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.authenticator.BaseOAuth20AuthenticatorTests;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.RetryingTest;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20ClientIdClientSecretAuthenticatorTests {

    @Import(value={NullPrincipalTestConfiguration.class})
    @Nested
    public class NullPrincipalResolutionTests
    extends BaseOAuth20AuthenticatorTests {
        @Test
        public void verifyAuthenticationWithoutResolvedPrincipal() {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("serviceWithAttributesMapping", "secret");
            OAuthRegisteredService service = new OAuthRegisteredService();
            service.setClientId(credentials.getUsername());
            this.servicesManager.save((RegisteredService)service);
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNotNull((Object)credentials.getUserProfile());
            Assertions.assertEquals((Object)credentials.getUsername(), (Object)credentials.getUserProfile().getId());
        }
    }

    @Nested
    public class DefaultPrincipalResolutionTests
    extends BaseOAuth20AuthenticatorTests {
        @RetryingTest(value=3)
        public void verifyAuthentication() {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "secret");
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNotNull((Object)credentials.getUserProfile());
            Assertions.assertEquals((Object)"client", (Object)credentials.getUserProfile().getId());
        }

        @Test
        public void verifyAuthenticationWithGrantTypePassword() {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "secret");
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            request.addParameter("grant_type", OAuth20GrantTypes.PASSWORD.name());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNull((Object)credentials.getUserProfile());
        }

        @Test
        public void verifyAuthenticationWithBadSecret() throws Exception {
            OAuth20RefreshToken refreshToken = DefaultPrincipalResolutionTests.getRefreshToken(this.service);
            this.ticketRegistry.addTicket((Ticket)refreshToken);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.service.getClientId(), UUID.randomUUID().toString());
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
            request.addParameter("refresh_token", refreshToken.getId());
            Assertions.assertThrows(CredentialsException.class, () -> this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
        }

        @Test
        public void verifyAuthenticationWithCodeChallengePkce() throws Exception {
            OAuth20RefreshToken refreshToken = DefaultPrincipalResolutionTests.getRefreshToken(this.service);
            this.ticketRegistry.addTicket((Ticket)refreshToken);
            OAuth20Code code = DefaultPrincipalResolutionTests.getCode();
            Mockito.when((Object)code.getCodeChallenge()).thenReturn((Object)UUID.randomUUID().toString());
            this.ticketRegistry.addTicket((Ticket)code);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.service.getClientId(), this.service.getClientSecret());
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
            request.addParameter("refresh_token", refreshToken.getId());
            request.addParameter("code", code.getId());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNull((Object)credentials.getUserProfile());
        }

        @Test
        public void verifyAuthenticationWithGrantTypeRefreshToken() throws Exception {
            OAuth20RefreshToken refreshToken = DefaultPrincipalResolutionTests.getRefreshToken(this.serviceWithoutSecret);
            this.ticketRegistry.addTicket((Ticket)refreshToken);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("serviceWithoutSecret", refreshToken.getId());
            OAuthRegisteredService registeredService = new OAuthRegisteredService();
            registeredService.setClientId(credentials.getUsername());
            this.servicesManager.save((RegisteredService)registeredService);
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
            request.addParameter("client_id", registeredService.getClientId());
            request.addParameter("refresh_token", refreshToken.getId());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNull((Object)credentials.getUserProfile());
            request.removeAllParameters();
            request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
            request.addParameter("refresh_token", refreshToken.getId());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNotNull((Object)credentials.getUserProfile());
            request.removeAllParameters();
            request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
            request.addParameter("client_id", registeredService.getClientId());
            request.addParameter("client_secret", "serviceWithoutSecret");
            request.addParameter("refresh_token", refreshToken.getId());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNotNull((Object)credentials.getUserProfile());
        }

        @Test
        public void verifyAuthenticationWithAttributesMapping() {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.serviceWithAttributesMapping.getClientId(), "secret");
            MockHttpServletRequest request = new MockHttpServletRequest();
            JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            this.oauthClientAuthenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
            Assertions.assertNotNull((Object)credentials.getUserProfile());
            Assertions.assertEquals((Object)credentials.getUsername().toLowerCase(), (Object)credentials.getUserProfile().getId());
            Assertions.assertNotNull((Object)credentials.getUserProfile().getAttribute("eduPersonAffiliation"));
            Assertions.assertNull((Object)credentials.getUserProfile().getAttribute("groupMembership"));
        }
    }

    @TestConfiguration(value="NullPrincipalTestConfiguration", proxyBeanMethods=false)
    public static class NullPrincipalTestConfiguration {
        @Bean
        public PrincipalResolver defaultPrincipalResolver() {
            PrincipalResolver mockPrincipalResolver = (PrincipalResolver)Mockito.mock(PrincipalResolver.class);
            Mockito.when((Object)mockPrincipalResolver.resolve((Credential)Mockito.any())).thenReturn((Object)NullPrincipal.getInstance());
            return mockPrincipalResolver;
        }
    }
}

