/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.authenticator.BaseOAuth20AuthenticatorTests;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20DefaultCasAuthenticationBuilderTests
extends BaseOAuth20AuthenticatorTests {
    @Autowired
    @Qualifier(value="oauthCasAuthenticationBuilder")
    private OAuth20CasAuthenticationBuilder authenticationBuilder;

    @Test
    public void verifyOperationByService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("X-".concat("service"), (Object)this.service.getServiceId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Service result = this.authenticationBuilder.buildService(this.service, (WebContext)ctx, true);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void verifyOperationToBuild() {
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        profile.addAuthenticationAttribute("clazz", (Object)"high");
        profile.addAttribute("cn", (Object)"casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("state", UUID.randomUUID().toString());
        request.addParameter("nonce", UUID.randomUUID().toString());
        request.addParameter("acr_values", "mfa-dummy");
        request.addHeader("X-".concat("service"), (Object)this.service.getServiceId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Authentication result = this.authenticationBuilder.build((UserProfile)profile, this.service, (WebContext)ctx, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.getPrincipal().getAttributes().containsKey("cn"));
        Assertions.assertTrue((boolean)result.getAttributes().containsKey("clazz"));
    }
}

