/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredServiceAccessStrategyAuditableEnforcer;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.BaseOAuth20AuthenticatorTests;
import org.apereo.cas.support.oauth.authenticator.OAuth20ProofKeyCodeExchangeAuthenticator;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20DefaultCode;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20ProofKeyCodeExchangeAuthenticatorTests
extends BaseOAuth20AuthenticatorTests {
    protected OAuth20ProofKeyCodeExchangeAuthenticator authenticator;

    @BeforeEach
    public void init() {
        this.authenticator = new OAuth20ProofKeyCodeExchangeAuthenticator(this.servicesManager, this.serviceFactory, (AuditableExecution)new RegisteredServiceAccessStrategyAuditableEnforcer(new CasConfigurationProperties()), this.ticketRegistry, this.defaultPrincipalResolver, this.oauthRequestParameterResolver, this.oauth20ClientSecretValidator);
    }

    @Test
    public void verifyNoToken() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("clientWithoutSecret", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "clientWithoutSecret");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("code", "CODE-1234567890");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(InvalidTicketException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAuthenticationPlainWithoutSecret() throws Exception {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("clientWithoutSecret", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.ticketRegistry.addTicket((Ticket)new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "ABCD123", "plain", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE));
        request.addParameter("client_id", "clientWithoutSecret");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("code", "CODE-1234567890");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"clientWithoutSecret", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAuthenticationPlainWithSecretTransmittedByFormAuthn() throws Exception {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.ticketRegistry.addTicket((Ticket)new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "ABCD123", "plain", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE));
        request.addParameter("client_id", "client");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("client_secret", "secret");
        request.addParameter("code", "CODE-1234567890");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"client", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAuthenticationPlainWithSecretTransmittedByBasicAuthn() throws Exception {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "secret");
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.ticketRegistry.addTicket((Ticket)new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "ABCD123", "plain", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE));
        request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"client:secret")));
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("code", "CODE-1234567890");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"client", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAuthenticationHashedWithoutSecret() throws Exception {
        String hash = EncodingUtils.encodeUrlSafeBase64((byte[])DigestUtils.rawDigestSha256((String)"ABCD123"));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("clientWithoutSecret", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        OAuth20DefaultCode ticket = new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), hash, "s256", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addParameter("client_id", "clientWithoutSecret");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("code", ticket.getId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"clientWithoutSecret", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyUnknownDigest() throws Exception {
        String hash = EncodingUtils.encodeUrlSafeBase64((byte[])DigestUtils.rawDigestSha256((String)"ABCD123"));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("clientWithoutSecret", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        OAuth20DefaultCode ticket = new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), hash, "unknown", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addParameter("client_id", "clientWithoutSecret");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("code", ticket.getId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAuthenticationHashedWithSecretTransmittedByFormAuthn() throws Exception {
        String hash = EncodingUtils.encodeUrlSafeBase64((byte[])DigestUtils.rawDigestSha256((String)"ABCD123"));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        OAuth20DefaultCode ticket = new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), hash, "s256", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addParameter("client_id", "client");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("client_secret", "secret");
        request.addParameter("code", ticket.getId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"client", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAuthenticationHashedWithSecretTransmittedByBasicFormAuthn() throws Exception {
        String hash = EncodingUtils.encodeUrlSafeBase64((byte[])DigestUtils.rawDigestSha256((String)"ABCD123"));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        OAuth20DefaultCode ticket = new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), hash, "s256", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"client:secret")));
        request.addHeader("Authorization", (Object)("Basic " + EncodingUtils.encodeBase64((String)"client:secret")));
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("code", ticket.getId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"client", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAuthenticationNotHashedCorrectly() throws Exception {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("client", "ABCD123");
        MockHttpServletRequest request = new MockHttpServletRequest();
        OAuth20DefaultCode ticket = new OAuth20DefaultCode("CODE-1234567890", (Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (ExpirationPolicy)new HardTimeoutExpirationPolicy(10L), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "something-else", "s256", "clientid12345", new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)ticket);
        request.addParameter("client_id", "client");
        request.addParameter("code_verifier", "ABCD123");
        request.addParameter("client_secret", "secret");
        request.addParameter("code", ticket.getId());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }
}

