/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredServiceAccessStrategyAuditableEnforcer;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.authenticator.BaseOAuth20AuthenticatorTests;
import org.apereo.cas.support.oauth.authenticator.OAuth20RefreshTokenAuthenticator;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junitpioneer.jupiter.RetryingTest;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20RefreshTokenAuthenticatorTests
extends BaseOAuth20AuthenticatorTests {
    protected OAuth20RefreshTokenAuthenticator authenticator;

    @BeforeEach
    public void init() {
        this.authenticator = new OAuth20RefreshTokenAuthenticator(this.servicesManager, this.serviceFactory, (AuditableExecution)new RegisteredServiceAccessStrategyAuditableEnforcer(new CasConfigurationProperties()), this.ticketRegistry, this.defaultPrincipalResolver, this.oauthRequestParameterResolver, this.oauth20ClientSecretValidator);
    }

    @RetryingTest(value=3)
    public void verifyAuthentication() throws Exception {
        OAuth20RefreshToken refreshToken = OAuth20RefreshTokenAuthenticatorTests.getRefreshToken(this.serviceWithoutSecret);
        this.ticketRegistry.addTicket((Ticket)refreshToken);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("clientWithoutSecret", refreshToken.getId());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
        request.addParameter("refresh_token", refreshToken.getId());
        request.addParameter("client_id", "clientWithoutSecret");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"clientWithoutSecret", (Object)credentials.getUserProfile().getId());
        UsernamePasswordCredentials badRefreshTokenCredentials = new UsernamePasswordCredentials("clientWithoutSecret", "badRefreshToken");
        MockHttpServletRequest badRefreshTokenRequest = new MockHttpServletRequest();
        badRefreshTokenRequest.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
        badRefreshTokenRequest.addParameter("refresh_token", "badRefreshToken");
        badRefreshTokenRequest.addParameter("client_id", "clientWithoutSecret");
        JEEContext badRefreshTokenCtx = new JEEContext((HttpServletRequest)badRefreshTokenRequest, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)badRefreshTokenCredentials, (WebContext)badRefreshTokenCtx, (SessionStore)JEESessionStore.INSTANCE));
        UsernamePasswordCredentials badClientIdCredentials = new UsernamePasswordCredentials("clientWithoutSecret2", refreshToken.getId());
        MockHttpServletRequest badClientIdRequest = new MockHttpServletRequest();
        badClientIdRequest.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
        badClientIdRequest.addParameter("refresh_token", refreshToken.getId());
        badClientIdRequest.addParameter("client_id", "clientWithoutSecret2");
        JEEContext badClientIdCtx = new JEEContext((HttpServletRequest)badClientIdRequest, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)badClientIdCredentials, (WebContext)badClientIdCtx, (SessionStore)JEESessionStore.INSTANCE));
        OAuth20RefreshToken unsupportedClientRefreshToken = OAuth20RefreshTokenAuthenticatorTests.getRefreshToken(this.service);
        this.ticketRegistry.addTicket((Ticket)unsupportedClientRefreshToken);
        UsernamePasswordCredentials unsupportedClientCredentials = new UsernamePasswordCredentials("client", refreshToken.getId());
        MockHttpServletRequest unsupportedClientRequest = new MockHttpServletRequest();
        unsupportedClientRequest.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
        unsupportedClientRequest.addParameter("refresh_token", unsupportedClientRefreshToken.getId());
        unsupportedClientRequest.addParameter("client_id", "client");
        JEEContext unsupportedClientCtx = new JEEContext((HttpServletRequest)unsupportedClientRequest, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)unsupportedClientCredentials, (WebContext)unsupportedClientCtx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)unsupportedClientCredentials.getUserProfile());
        UsernamePasswordCredentials unknownClientCredentials = new UsernamePasswordCredentials("unknownclient", refreshToken.getId());
        MockHttpServletRequest unknownclientRequest = new MockHttpServletRequest();
        unknownclientRequest.addParameter("grant_type", OAuth20GrantTypes.REFRESH_TOKEN.name());
        unknownclientRequest.addParameter("refresh_token", unsupportedClientRefreshToken.getId());
        unknownclientRequest.addParameter("client_id", "unknownclient");
        JEEContext unknownclientCtx = new JEEContext((HttpServletRequest)unknownclientRequest, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)unknownClientCredentials, (WebContext)unknownclientCtx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)unknownClientCredentials.getUserProfile());
    }
}

