/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.support.oauth.authenticator.BaseOAuth20AuthenticatorTests;
import org.apereo.cas.support.oauth.authenticator.OAuth20UsernamePasswordAuthenticator;
import org.apereo.cas.util.HttpUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20UsernamePasswordAuthenticatorTests
extends BaseOAuth20AuthenticatorTests {
    protected OAuth20UsernamePasswordAuthenticator authenticator;

    @BeforeEach
    public void init() {
        this.authenticator = new OAuth20UsernamePasswordAuthenticator(this.authenticationSystemSupport, this.servicesManager, this.serviceFactory, (SessionStore)JEESessionStore.INSTANCE, this.oauthRequestParameterResolver, this.oauth20ClientSecretValidator);
    }

    @Test
    public void verifyAcceptedCredentialsWithClientId() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "clientWithoutSecret");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"casuser", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAcceptedCredentialsWithClientSecret() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "client");
        request.addParameter("client_secret", "secret");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"casuser", (Object)credentials.getUserProfile().getId());
    }

    @Test
    public void verifyAcceptedCredentialsWithBadClientSecret() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "client");
        request.addParameter("client_secret", "secretnotfound");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAcceptedCredentialsWithServiceDisabled() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "client");
        this.service.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(false, false));
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAcceptedCredentialsWithBadCredentials() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser-something", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "client");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAcceptedCredentialsWithoutClientSecret() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "client");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAcceptedCredentialsWithoutClientId() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assertions.assertThrows(CredentialsException.class, () -> this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE));
    }

    @Test
    public void verifyAcceptedCredentialsWithClientSecretWithBasicAuth() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("casuser", "casuser");
        MockHttpServletRequest request = new MockHttpServletRequest();
        HttpHeaders headers = HttpUtils.createBasicAuthHeaders((String)"client", (String)"secret");
        List authz = headers.get((Object)"Authorization");
        Assertions.assertNotNull((Object)authz);
        request.addHeader("Authorization", (Object)authz);
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate((Credentials)credentials, (WebContext)ctx, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((Object)"casuser", (Object)credentials.getUserProfile().getId());
    }
}

