/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.logout;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutPostProcessor;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@SpringBootTest(classes={OAuthDistributedSessionTestConfiguration.class, AbstractOAuth20Tests.SharedTestConfiguration.class}, properties={"cas.authn.attribute-repository.stub.attributes.uid=cas", "cas.authn.attribute-repository.stub.attributes.givenName=apereo-cas", "spring.main.allow-bean-definition-overriding=true", "cas.authn.oauth.session-replication.replicate-sessions=true"})
@EnableTransactionManagement(proxyTargetClass=false)
@EnableAspectJAutoProxy(proxyTargetClass=false)
@Tag(value="OAuth")
public class OAuth20LogoutReplicateSessionTests {
    @Autowired
    @Qualifier(value="logoutExecutionPlan")
    private LogoutExecutionPlan logoutExecutionPlan;

    @Test
    public void verifyThatTheOAuthSpecificLogoutPostProcessorApplies() throws Exception {
        Collection processors = this.logoutExecutionPlan.getLogoutPostProcessors();
        Assertions.assertEquals((int)1, (int)processors.size());
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response));
        TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        LogoutPostProcessor processor = (LogoutPostProcessor)processors.iterator().next();
        processor.handle(tgt);
        ((SessionStore)Mockito.verify((Object)OAuthDistributedSessionTestConfiguration.SESSION_STORE)).destroySession((WebContext)Mockito.any(JEEContext.class));
    }

    @TestConfiguration(value="OAuthDistributedSessionTestConfiguration", proxyBeanMethods=false)
    public static class OAuthDistributedSessionTestConfiguration {
        private static final SessionStore SESSION_STORE = (SessionStore)Mockito.mock(SessionStore.class);

        @Bean
        public SessionStore oauthDistributedSessionStore() {
            return SESSION_STORE;
        }
    }
}

