/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.profile;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.OAuth20ClientIdAwareProfileManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20ClientIdAwareProfileManagerTests
extends AbstractOAuth20Tests {
    protected OAuth20ClientIdAwareProfileManager profileManager;
    protected JEEContext context;

    @BeforeEach
    public void init() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", "1");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        this.profileManager = new OAuth20ClientIdAwareProfileManager((WebContext)this.context, this.oauthDistributedSessionStore, this.servicesManager, this.oauthRequestParameterResolver);
    }

    @Test
    public void verifyGetProfiles() {
        CommonProfile profile = new CommonProfile();
        profile.setId("casuser");
        profile.setClientName("1");
        this.profileManager.save(true, (UserProfile)profile, false);
        List profiles = this.profileManager.getProfiles();
        Assertions.assertNotNull((Object)profiles);
        Assertions.assertEquals((int)1, (int)profiles.size());
    }

    @Test
    public void verifyGetProfilesWithoutSavedClientId() {
        CommonProfile profile = new CommonProfile();
        profile.setId("casuser");
        profile.setClientName("1");
        HashMap<String, CommonProfile> sessionProfiles = new HashMap<String, CommonProfile>(1);
        sessionProfiles.put("1", profile);
        this.oauthDistributedSessionStore.set((WebContext)this.context, "pac4jUserProfiles", sessionProfiles);
        List profiles = this.profileManager.getProfiles();
        Assertions.assertNotNull((Object)profiles);
        Assertions.assertEquals((int)0, (int)profiles.size());
    }
}

