/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Tag(value="OAuth")
public class OAuth20AuthenticationServiceSelectionStrategyTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy")
    private AuthenticationServiceSelectionStrategy strategy;

    @Test
    public void verifyNullService() {
        Assertions.assertNotNull((Object)this.strategy.resolveServiceFrom((Service)Mockito.mock(Service.class)));
    }

    @Test
    public void verifyGrantType() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("X-service", (Object)"https://example.com");
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Service service = this.strategy.resolveServiceFrom((Service)RegisteredServiceTestUtils.getService((String)("https://example.org?client_id=1&grant_type=" + OAuth20GrantTypes.CLIENT_CREDENTIALS.getType())));
        Assertions.assertNotNull((Object)service);
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("client_id"));
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("grant_type"));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)this.strategy.getOrder());
    }

    @Test
    public void verifyJwtRequest() {
        JWTClaimsSet claims = new JWTClaimsSet.Builder().subject("cas").claim("scope", (Object)new String[]{"profile"}).claim("redirect_uri", (Object)"http://someurl").claim("grant_type", (Object)OAuth20GrantTypes.CLIENT_CREDENTIALS.getType()).claim("client_id", (Object)"1").build();
        PlainJWT jwt = new PlainJWT(claims);
        String jwtRequest = jwt.serialize();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("request", jwtRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Service service = this.strategy.resolveServiceFrom((Service)RegisteredServiceTestUtils.getService((String)("https://example.org?request=" + jwtRequest)));
        Assertions.assertNotNull((Object)service);
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("client_id"));
    }

    @Test
    public void verifyBadRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Service service = this.strategy.resolveServiceFrom((Service)RegisteredServiceTestUtils.getService((String)"https://example.org"));
        Assertions.assertNotNull((Object)service);
        Assertions.assertEquals((int)1, (int)service.getAttributes().size());
        Assertions.assertTrue((boolean)service.getAttributes().containsKey("service"));
    }
}

