/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.PartialRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Tag(value="OAuth")
public class OAuth20ServicesManagerRegisteredServiceLocatorTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauthServicesManagerRegisteredServiceLocator")
    private ServicesManagerRegisteredServiceLocator oauthServicesManagerRegisteredServiceLocator;

    @Override
    @BeforeEach
    public void setup() {
        super.setup();
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyOperation() {
        Assertions.assertNotNull((Object)this.oauthServicesManagerRegisteredServiceLocator);
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)this.oauthServicesManagerRegisteredServiceLocator.getOrder());
        OAuthRegisteredService service = OAuth20ServicesManagerRegisteredServiceLocatorTests.getRegisteredService("clientid123456", UUID.randomUUID().toString());
        service.setMatchingStrategy((RegisteredServiceMatchingStrategy)new PartialRegexRegisteredServiceMatchingStrategy());
        WebApplicationService svc = (WebApplicationService)this.serviceFactory.createService(String.format("https://oauth.example.org/whatever?%s=%s", "client_id", service.getClientId()));
        RegisteredService result = this.oauthServicesManagerRegisteredServiceLocator.locate(List.of(service), (Service)svc);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void verifyWithCallback() throws Exception {
        String callbackUrl = "http://localhost:8443/cas/oauth2.0/callbackAuthorize";
        CasRegisteredService service0 = RegisteredServiceTestUtils.getRegisteredService((String)"http://localhost:8443/cas/oauth2.0/callbackAuthorize.*");
        service0.setEvaluationOrder(0);
        OAuthRegisteredService service1 = OAuth20ServicesManagerRegisteredServiceLocatorTests.getRegisteredService("http://localhost:8080/app1", "application1", "secret1");
        service1.setEvaluationOrder(100);
        OAuthRegisteredService service2 = OAuth20ServicesManagerRegisteredServiceLocatorTests.getRegisteredService(".+", "application2", "secret2");
        service2.setEvaluationOrder(1000);
        List candidateServices = CollectionUtils.wrapList((Object[])new BaseWebBasedRegisteredService[]{service0, service1, service2});
        this.servicesManager.save(candidateServices.toArray(new RegisteredService[0]));
        Collections.sort(candidateServices);
        URIBuilder url = new URIBuilder("http://localhost:8443/cas/oauth2.0/callbackAuthorize?client_id=application1");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost:8443/cas/oauth2.0/callbackAuthorize");
        url.getQueryParams().forEach(param -> request.addParameter(param.getName(), param.getValue()));
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebApplicationService service = (WebApplicationService)this.serviceFactory.createService(url.toString());
        RegisteredService result = this.servicesManager.findServiceBy((Service)service);
        Assertions.assertEquals((Object)service1, (Object)result);
    }
}

