/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuth")
public class OAuth20WebApplicationServiceTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "oAuthWebApplicationService.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    @Test
    public void verifySerializeACompletePrincipalToJson() throws Exception {
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setName("checkCloning");
        service.setServiceId("testId");
        service.setTheme("theme");
        service.setDescription("description");
        WebApplicationServiceFactory factory = new WebApplicationServiceFactory();
        WebApplicationService serviceWritten = factory.createService(service.getServiceId());
        MAPPER.writeValue(JSON_FILE, (Object)serviceWritten);
        WebApplicationService serviceRead = (WebApplicationService)MAPPER.readValue(JSON_FILE, WebApplicationService.class);
        Assertions.assertEquals((Object)serviceWritten, (Object)serviceRead);
    }
}

