/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.util;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.FullRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OAuth")
public class OAuth20UtilsTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyRequestHeaderBad() {
        Assertions.assertNull((Object)OAuth20Utils.getClientIdFromAuthenticatedProfile((UserProfile)new CommonProfile()));
    }

    @Test
    public void verifyUnauthzView() {
        ModelAndView mv = OAuth20Utils.produceUnauthorizedErrorView();
        Assertions.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)mv.getStatus());
    }

    @Test
    public void verifyNoClientId() {
        Assertions.assertNull((Object)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((ServicesManager)Mockito.mock(ServicesManager.class)), null));
    }

    @Test
    public void verifyRequestParams() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addParameter("attr1", "value1");
        request.addParameter("attr2", new String[]{"value2", "value3"});
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameters(List.of("attr1", "attr2"), (WebContext)context).isEmpty());
    }

    @Test
    public void verifyRequestParam() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addParameter("attr1", "value1");
        request.addParameter("attr2", new String[]{"value2", "value3"});
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "attr1", String.class).isEmpty());
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "attr2", List.class).isEmpty());
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "attr2", String[].class).isEmpty());
    }

    @Test
    public void verifyRequestParamJwt() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        JWTClaimsSet claims = new JWTClaimsSet.Builder().subject("cas").claim("scope", (Object)new String[]{"openid", "profile"}).claim("response", (Object)"code").claim("client_id", List.of("client1", "client2")).build();
        PlainJWT jwt = new PlainJWT(claims);
        String jwtString = jwt.serialize();
        request.removeAllParameters();
        request.addParameter("request", jwtString);
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "response", String.class).isEmpty());
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "client_id", List.class).isEmpty());
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "scope", String[].class).isEmpty());
    }

    @Test
    public void verifyScopes() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addParameter("scope", new String[]{"openid", "profile"});
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.resolveRequestedScopes((WebContext)context).isEmpty());
        Assertions.assertTrue((boolean)this.oauthRequestParameterResolver.resolveRequestedScopes((WebContext)new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response)).isEmpty());
    }

    @Test
    public void verifyPostResponse() {
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setClientId("clientid");
        registeredService.setResponseType("post");
        Assertions.assertTrue((boolean)OAuth20Utils.isResponseModeTypeFormPost((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)OAuth20ResponseModeTypes.NONE));
        Assertions.assertTrue((boolean)OAuth20Utils.isResponseModeType((String)"form_post", (OAuth20ResponseModeTypes)OAuth20ResponseModeTypes.FORM_POST));
    }

    @Test
    public void verifyGrants() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addParameter("grant_type", OAuth20GrantTypes.CLIENT_CREDENTIALS.getType());
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setClientId("clientid");
        registeredService.setSupportedGrantTypes((Set)CollectionUtils.wrapHashSet((Object[])new String[]{OAuth20GrantTypes.CLIENT_CREDENTIALS.getType()}));
        Assertions.assertTrue((boolean)this.oauthRequestParameterResolver.isAuthorizedGrantTypeForService((WebContext)context, registeredService));
        Assertions.assertTrue((boolean)OAuth20RequestParameterResolver.isAuthorizedGrantTypeForService((String)OAuth20GrantTypes.PASSWORD.getType(), (OAuthRegisteredService)new OAuthRegisteredService()));
    }

    @Test
    public void verifyCheckCallbackValid() {
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setServiceId("http://test.org/.*");
        registeredService.setMatchingStrategy(null);
        Assertions.assertFalse((boolean)OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, (String)"http://test.org/cas"));
        registeredService.setMatchingStrategy((RegisteredServiceMatchingStrategy)new FullRegexRegisteredServiceMatchingStrategy());
        Assertions.assertTrue((boolean)OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, (String)"http://test.org/cas"));
        Assertions.assertFalse((boolean)OAuth20Utils.checkCallbackValid((RegisteredService)registeredService, (String)"http://test2.org/cas"));
    }

    @Test
    public void verifyServiceHeader() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.addHeader("X-".concat("service"), (Object)"https://google.com");
        String result = OAuth20Utils.getServiceRequestHeaderIfAny((WebContext)context);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void verifyUserInfoClaims() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String claims = "\"userinfo\": {\"given_name\": {\"essential\": true}}";
        request.addParameter("claims", "\"userinfo\": {\"given_name\": {\"essential\": true}}");
        Map result = this.oauthRequestParameterResolver.resolveRequestClaims((WebContext)context);
        Assertions.assertFalse((boolean)result.isEmpty());
        OAuth20Token token = (OAuth20Token)Mockito.mock(OAuth20Token.class);
        Mockito.when((Object)token.getClaims()).thenReturn(Map.of("userinfo", Map.of("givenName", "CAS")));
        Assertions.assertFalse((boolean)OAuth20Utils.parseUserInfoRequestClaims((OAuth20Token)token).isEmpty());
    }

    @Test
    public void verifyIsAuthorizedResponseTypeForService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("response_type", OAuth20ResponseTypes.ID_TOKEN.getType());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        HashSet<String> supportedResponseTypes = new HashSet<String>();
        registeredService.setSupportedResponseTypes(supportedResponseTypes);
        Assertions.assertTrue((boolean)this.oauthRequestParameterResolver.isAuthorizedResponseTypeForService((WebContext)context, registeredService));
        supportedResponseTypes.add(OAuth20ResponseTypes.IDTOKEN_TOKEN.getType());
        registeredService.setSupportedResponseTypes(supportedResponseTypes);
        Assertions.assertFalse((boolean)this.oauthRequestParameterResolver.isAuthorizedResponseTypeForService((WebContext)context, registeredService));
        supportedResponseTypes.add(OAuth20ResponseTypes.ID_TOKEN.getType());
        registeredService.setSupportedResponseTypes(supportedResponseTypes);
        Assertions.assertTrue((boolean)this.oauthRequestParameterResolver.isAuthorizedResponseTypeForService((WebContext)context, registeredService));
    }
}

