/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OAuth")
public class DefaultOAuth20ClientSecretValidatorTests
extends AbstractOAuth20Tests {
    @Test
    public void verifyClientSecretCheck() {
        String secret = RandomUtils.randomAlphanumeric((int)12);
        String encodedSecret = (String)this.oauth20ClientSecretValidator.getCipherExecutor().encode((Object)secret);
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setClientId("clientid");
        registeredService.setClientSecret(encodedSecret);
        boolean result = this.oauth20ClientSecretValidator.validate(registeredService, secret);
        Assertions.assertTrue((boolean)result);
        Assertions.assertFalse((boolean)this.oauth20ClientSecretValidator.isClientSecretExpired(registeredService));
    }

    @Test
    public void verifyClientSecretIsWrong() {
        String secret = RandomUtils.randomAlphanumeric((int)12);
        String encodedSecret = (String)this.oauth20ClientSecretValidator.getCipherExecutor().encode((Object)secret);
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setClientId("clientid");
        registeredService.setClientSecret(encodedSecret);
        boolean result = this.oauth20ClientSecretValidator.validate(registeredService, "badSecret");
        Assertions.assertFalse((boolean)result);
    }

    @Test
    public void verifyClientSecretCheckWithoutCipher() {
        String secret = RandomUtils.randomAlphanumeric((int)12);
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setClientId("clientid");
        registeredService.setClientSecret(secret);
        boolean result = this.oauth20ClientSecretValidator.validate(registeredService, secret);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void verifyClientSecretUndefined() {
        String secret = RandomUtils.randomAlphanumeric((int)12);
        OAuthRegisteredService registeredService = new OAuthRegisteredService();
        registeredService.setClientId("clientid");
        boolean result = this.oauth20ClientSecretValidator.validate(registeredService, secret);
        Assertions.assertTrue((boolean)result);
    }
}

