/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyAuditableEnforcer;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidatorTests
extends AbstractOAuth20Tests {
    private static ServicesManager getServicesManager(StaticApplicationContext applicationContext) {
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)new InMemoryServiceRegistry((ConfigurableApplicationContext)applicationContext)).applicationContext((ConfigurableApplicationContext)applicationContext).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        return new DefaultServicesManager(context);
    }

    private OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator getValidator(ServicesManager serviceManager) {
        return new OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator(serviceManager, (ServiceFactory)new WebApplicationServiceFactory(), (AuditableExecution)new RegisteredServiceAccessStrategyAuditableEnforcer(this.casProperties), this.oauthRequestParameterResolver);
    }

    private static OAuthRegisteredService buildRegisteredService(ServicesManager serviceManager) {
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setId(1000L);
        service.setName("OAuth");
        service.setClientId("client");
        service.setClientSecret("secret");
        service.setServiceId("https://.+");
        serviceManager.save((RegisteredService)service);
        return service;
    }

    @Test
    public void verifyUnsignedRequestParameter() throws Exception {
        StaticApplicationContext ctx = new StaticApplicationContext();
        ctx.refresh();
        ServicesManager serviceManager = OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidatorTests.getServicesManager(ctx);
        OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidatorTests.buildRegisteredService(serviceManager);
        OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator validator = this.getValidator(serviceManager);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String authnRequest = "eyJhbGciOiJub25lIn0.eyJzY29wZSI6Im9wZW5pZCIsInJlc3BvbnNlX3R5cGUiOiJjb2RlIiwicmVkaXJlY3RfdXJpIjoiaHR0cHM6XC9cL3N0YWdpbmcuY2VydGlmaWNhdGlvbi5vcGVuaWQubmV0XC90ZXN0XC9hXC9DQVNcL2NhbGxiYWNrIiwic3RhdGUiOiJ2SU4xYjBZNENrIiwibm9uY2UiOiIxTjltcVBPOWZ0IiwiY2xpZW50X2lkIjoiY2xpZW50In0.";
        request.setParameter("request", "eyJhbGciOiJub25lIn0.eyJzY29wZSI6Im9wZW5pZCIsInJlc3BvbnNlX3R5cGUiOiJjb2RlIiwicmVkaXJlY3RfdXJpIjoiaHR0cHM6XC9cL3N0YWdpbmcuY2VydGlmaWNhdGlvbi5vcGVuaWQubmV0XC90ZXN0XC9hXC9DQVNcL2NhbGxiYWNrIiwic3RhdGUiOiJ2SU4xYjBZNENrIiwibm9uY2UiOiIxTjltcVBPOWZ0IiwiY2xpZW50X2lkIjoiY2xpZW50In0.");
        Assertions.assertTrue((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)validator.validate((WebContext)context));
    }

    @Test
    public void verifyValidator() throws Exception {
        StaticApplicationContext ctx = new StaticApplicationContext();
        ctx.refresh();
        ServicesManager serviceManager = OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidatorTests.getServicesManager(ctx);
        OAuthRegisteredService service = OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidatorTests.buildRegisteredService(serviceManager);
        OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator validator = this.getValidator(serviceManager);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"invalid_request", (Object)context.getRequestAttribute("error").get().toString());
        request.removeAttribute("error");
        request.setParameter("grant_type", OAuth20GrantTypes.AUTHORIZATION_CODE.getType());
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        request.removeAttribute("error");
        request.setParameter("client_id", "client");
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"invalid_request", (Object)context.getRequestAttribute("error").get().toString());
        request.removeAttribute("error");
        request.setParameter("redirect_uri", service.getServiceId());
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"unsupported_response_type", (Object)context.getRequestAttribute("error").get().toString());
        request.removeAttribute("error");
        request.setParameter("response_type", "unknown");
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"unsupported_response_type", (Object)context.getRequestAttribute("error").get().toString());
        request.removeAttribute("error");
        request.setParameter("response_type", OAuth20ResponseTypes.CODE.getType());
        request.setParameter("code_verifier", "abcd");
        service.setSupportedResponseTypes(new LinkedHashSet());
        Assertions.assertTrue((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)validator.validate((WebContext)context));
        request.removeAttribute("error");
        Assertions.assertTrue((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)validator.validate((WebContext)context));
        Assertions.assertFalse((boolean)context.getRequestAttribute("error").isPresent());
        request.removeAttribute("error");
        service.setSupportedResponseTypes((Set)CollectionUtils.wrapHashSet((Object[])new String[]{OAuth20ResponseTypes.CODE.getType()}));
        Assertions.assertTrue((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)validator.validate((WebContext)context));
        Assertions.assertFalse((boolean)context.getRequestAttribute("error").isPresent());
        request.removeAttribute("error");
        service.setSupportedResponseTypes((Set)CollectionUtils.wrapHashSet((Object[])new String[]{OAuth20ResponseTypes.TOKEN.getType()}));
        Assertions.assertTrue((boolean)validator.supports((WebContext)context));
        Assertions.assertFalse((boolean)validator.validate((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        request.removeAttribute("error");
        request.setParameter("redirect_uri", "unknown-uri");
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"invalid_request", (Object)context.getRequestAttribute("error").get().toString());
        request.removeAttribute("error");
        request.setParameter("redirect_uri", service.getServiceId());
        service.getAccessStrategy().setServiceAccessAllowed(false);
        Assertions.assertFalse((boolean)validator.supports((WebContext)context));
        Assertions.assertTrue((boolean)context.getRequestAttribute("error").isPresent());
        Assertions.assertEquals((Object)"invalid_request", (Object)context.getRequestAttribute("error").get().toString());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)validator.getOrder());
        Assertions.assertNotNull((Object)validator.getRegisteredServiceAccessStrategyEnforcer());
        Assertions.assertEquals((Object)OAuth20ResponseTypes.CODE, (Object)validator.getResponseType());
        Assertions.assertNotNull((Object)validator.getServicesManager());
        Assertions.assertNotNull((Object)validator.getWebApplicationServiceServiceFactory());
    }
}

