/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.services.RegisteredServiceAccessStrategyAuditableEnforcer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20IdTokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20IdTokenResponseTypeAuthorizationRequestValidatorTests
extends AbstractOAuth20Tests {
    @Test
    public void verifySupports() throws Exception {
        ServicesManager serviceManager = (ServicesManager)Mockito.mock(ServicesManager.class);
        OAuthRegisteredService service = new OAuthRegisteredService();
        service.setName("OAuth");
        service.setClientId("client");
        service.setClientSecret("secret");
        service.setServiceId("https://callback.example.org");
        Mockito.when((Object)serviceManager.getAllServices()).thenReturn((Object)CollectionUtils.toCollection((Object)service));
        Mockito.when((Object)serviceManager.getAllServicesOfType((Class)Mockito.any())).thenReturn((Object)CollectionUtils.toCollection((Object)service));
        OAuth20IdTokenResponseTypeAuthorizationRequestValidator v = new OAuth20IdTokenResponseTypeAuthorizationRequestValidator(serviceManager, (ServiceFactory)new WebApplicationServiceFactory(), (AuditableExecution)new RegisteredServiceAccessStrategyAuditableEnforcer(this.casProperties), this.oauthRequestParameterResolver);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        request.setParameter("response_type", OAuth20ResponseTypes.CODE.getType());
        request.setParameter("client_id", "client");
        request.setParameter("redirect_uri", service.getServiceId());
        Assertions.assertFalse((boolean)v.supports((WebContext)context));
        request.setParameter("response_type", OAuth20ResponseTypes.ID_TOKEN.getType());
        Assertions.assertTrue((boolean)v.supports((WebContext)context));
    }
}

