/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.AbstractOAuth20Tests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OAuth")
public class OAuth20ProofKeyCodeExchangeResponseTypeAuthorizationRequestValidatorTests
extends AbstractOAuth20Tests {
    @Autowired
    @Qualifier(value="oauthProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator")
    private OAuth20AuthorizationRequestValidator validator;

    @Test
    public void verifySupports() throws Exception {
        OAuthRegisteredService service = OAuth20ProofKeyCodeExchangeResponseTypeAuthorizationRequestValidatorTests.getRegisteredService("client", "secret");
        this.servicesManager.save((RegisteredService)service);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertFalse((boolean)this.validator.supports((WebContext)context));
        request.setParameter("client_id", "client");
        request.setParameter("redirect_uri", service.getServiceId());
        request.setParameter("response_type", OAuth20ResponseTypes.TOKEN.getType());
        request.setParameter("code_verifier", "abcd");
        Assertions.assertFalse((boolean)this.validator.supports((WebContext)context));
        request.setParameter("response_type", OAuth20ResponseTypes.CODE.getType());
        Assertions.assertTrue((boolean)this.validator.supports((WebContext)context));
    }
}

